/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Remove PowerPoint PPTX Presentation Slides request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "StartDeleteSlideNumber", "EndDeleteSlideNumber"})
@JsonTypeName(value="RemovePptxSlidesRequest")
public class RemovePptxSlidesRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_START_DELETE_SLIDE_NUMBER = "StartDeleteSlideNumber";
    private Integer startDeleteSlideNumber;
    public static final String JSON_PROPERTY_END_DELETE_SLIDE_NUMBER = "EndDeleteSlideNumber";
    private Integer endDeleteSlideNumber;

    public RemovePptxSlidesRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public RemovePptxSlidesRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public RemovePptxSlidesRequest startDeleteSlideNumber(Integer startDeleteSlideNumber) {
        this.startDeleteSlideNumber = startDeleteSlideNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Slide number (1-based) to start deleting slides; inclusive")
    @JsonProperty(value="StartDeleteSlideNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStartDeleteSlideNumber() {
        return this.startDeleteSlideNumber;
    }

    public void setStartDeleteSlideNumber(Integer startDeleteSlideNumber) {
        this.startDeleteSlideNumber = startDeleteSlideNumber;
    }

    public RemovePptxSlidesRequest endDeleteSlideNumber(Integer endDeleteSlideNumber) {
        this.endDeleteSlideNumber = endDeleteSlideNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Slide number (1-based) to stop deleting slides; inclusive")
    @JsonProperty(value="EndDeleteSlideNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getEndDeleteSlideNumber() {
        return this.endDeleteSlideNumber;
    }

    public void setEndDeleteSlideNumber(Integer endDeleteSlideNumber) {
        this.endDeleteSlideNumber = endDeleteSlideNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemovePptxSlidesRequest removePptxSlidesRequest = (RemovePptxSlidesRequest)o;
        return Arrays.equals(this.inputFileBytes, removePptxSlidesRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, removePptxSlidesRequest.inputFileUrl) && Objects.equals(this.startDeleteSlideNumber, removePptxSlidesRequest.startDeleteSlideNumber) && Objects.equals(this.endDeleteSlideNumber, removePptxSlidesRequest.endDeleteSlideNumber);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.startDeleteSlideNumber, this.endDeleteSlideNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RemovePptxSlidesRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    startDeleteSlideNumber: ").append(this.toIndentedString(this.startDeleteSlideNumber)).append("\n");
        sb.append("    endDeleteSlideNumber: ").append(this.toIndentedString(this.endDeleteSlideNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

