/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Remove Word DOCX Document Pages request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "StartDeletePageNumber", "EndDeletePageNumber"})
@JsonTypeName(value="RemoveDocxPagesRequest")
public class RemoveDocxPagesRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_START_DELETE_PAGE_NUMBER = "StartDeletePageNumber";
    private Integer startDeletePageNumber;
    public static final String JSON_PROPERTY_END_DELETE_PAGE_NUMBER = "EndDeletePageNumber";
    private Integer endDeletePageNumber;

    public RemoveDocxPagesRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public RemoveDocxPagesRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public RemoveDocxPagesRequest startDeletePageNumber(Integer startDeletePageNumber) {
        this.startDeletePageNumber = startDeletePageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Page number (1-based) to start deleting pages; inclusive")
    @JsonProperty(value="StartDeletePageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStartDeletePageNumber() {
        return this.startDeletePageNumber;
    }

    public void setStartDeletePageNumber(Integer startDeletePageNumber) {
        this.startDeletePageNumber = startDeletePageNumber;
    }

    public RemoveDocxPagesRequest endDeletePageNumber(Integer endDeletePageNumber) {
        this.endDeletePageNumber = endDeletePageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Page number (1-based) to stop deleting pages; inclusive")
    @JsonProperty(value="EndDeletePageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getEndDeletePageNumber() {
        return this.endDeletePageNumber;
    }

    public void setEndDeletePageNumber(Integer endDeletePageNumber) {
        this.endDeletePageNumber = endDeletePageNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveDocxPagesRequest removeDocxPagesRequest = (RemoveDocxPagesRequest)o;
        return Arrays.equals(this.inputFileBytes, removeDocxPagesRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, removeDocxPagesRequest.inputFileUrl) && Objects.equals(this.startDeletePageNumber, removeDocxPagesRequest.startDeletePageNumber) && Objects.equals(this.endDeletePageNumber, removeDocxPagesRequest.endDeletePageNumber);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.startDeletePageNumber, this.endDeletePageNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RemoveDocxPagesRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    startDeletePageNumber: ").append(this.toIndentedString(this.startDeletePageNumber)).append("\n");
        sb.append("    endDeletePageNumber: ").append(this.toIndentedString(this.endDeletePageNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

