/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.ReceiptLineItem;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Result of recognizing a receipt, to extract the key information from the receipt")
@JsonPropertyOrder(value={"Successful", "Timestamp", "BusinessName", "BusinessWebsite", "AddressString", "PhoneNumber", "ReceiptItems", "ReceiptSubTotal", "ReceiptTotal"})
@JsonTypeName(value="ReceiptRecognitionResult")
public class ReceiptRecognitionResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_TIMESTAMP = "Timestamp";
    private OffsetDateTime timestamp;
    public static final String JSON_PROPERTY_BUSINESS_NAME = "BusinessName";
    private String businessName;
    public static final String JSON_PROPERTY_BUSINESS_WEBSITE = "BusinessWebsite";
    private String businessWebsite;
    public static final String JSON_PROPERTY_ADDRESS_STRING = "AddressString";
    private String addressString;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "PhoneNumber";
    private String phoneNumber;
    public static final String JSON_PROPERTY_RECEIPT_ITEMS = "ReceiptItems";
    private List<ReceiptLineItem> receiptItems = null;
    public static final String JSON_PROPERTY_RECEIPT_SUB_TOTAL = "ReceiptSubTotal";
    private Double receiptSubTotal;
    public static final String JSON_PROPERTY_RECEIPT_TOTAL = "ReceiptTotal";
    private Double receiptTotal;

    public ReceiptRecognitionResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public ReceiptRecognitionResult timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time printed on the receipt (if included on the receipt)")
    @JsonProperty(value="Timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public ReceiptRecognitionResult businessName(String businessName) {
        this.businessName = businessName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the business printed on the receipt (if included on the receipt)")
    @JsonProperty(value="BusinessName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public ReceiptRecognitionResult businessWebsite(String businessWebsite) {
        this.businessWebsite = businessWebsite;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The website URL of the business printed on the receipt (if included on the receipt)")
    @JsonProperty(value="BusinessWebsite")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessWebsite() {
        return this.businessWebsite;
    }

    public void setBusinessWebsite(String businessWebsite) {
        this.businessWebsite = businessWebsite;
    }

    public ReceiptRecognitionResult addressString(String addressString) {
        this.addressString = addressString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The address of the business printed on the receipt (if included on the receipt)")
    @JsonProperty(value="AddressString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddressString() {
        return this.addressString;
    }

    public void setAddressString(String addressString) {
        this.addressString = addressString;
    }

    public ReceiptRecognitionResult phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The phone number printed on the receipt (if included on the receipt)")
    @JsonProperty(value="PhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public ReceiptRecognitionResult receiptItems(List<ReceiptLineItem> receiptItems) {
        this.receiptItems = receiptItems;
        return this;
    }

    public ReceiptRecognitionResult addReceiptItemsItem(ReceiptLineItem receiptItemsItem) {
        if (this.receiptItems == null) {
            this.receiptItems = new ArrayList<ReceiptLineItem>();
        }
        this.receiptItems.add(receiptItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The individual line items comprising the order; does not include total (see ReceiptTotal)")
    @JsonProperty(value="ReceiptItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ReceiptLineItem> getReceiptItems() {
        return this.receiptItems;
    }

    public void setReceiptItems(List<ReceiptLineItem> receiptItems) {
        this.receiptItems = receiptItems;
    }

    public ReceiptRecognitionResult receiptSubTotal(Double receiptSubTotal) {
        this.receiptSubTotal = receiptSubTotal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; if available, the monetary value of the receipt subtotal - typically not including specialized line items such as Tax. If this value is not available, it will be 0.")
    @JsonProperty(value="ReceiptSubTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getReceiptSubTotal() {
        return this.receiptSubTotal;
    }

    public void setReceiptSubTotal(Double receiptSubTotal) {
        this.receiptSubTotal = receiptSubTotal;
    }

    public ReceiptRecognitionResult receiptTotal(Double receiptTotal) {
        this.receiptTotal = receiptTotal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total monetary value of the receipt (if included on the receipt)")
    @JsonProperty(value="ReceiptTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getReceiptTotal() {
        return this.receiptTotal;
    }

    public void setReceiptTotal(Double receiptTotal) {
        this.receiptTotal = receiptTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReceiptRecognitionResult receiptRecognitionResult = (ReceiptRecognitionResult)o;
        return Objects.equals(this.successful, receiptRecognitionResult.successful) && Objects.equals(this.timestamp, receiptRecognitionResult.timestamp) && Objects.equals(this.businessName, receiptRecognitionResult.businessName) && Objects.equals(this.businessWebsite, receiptRecognitionResult.businessWebsite) && Objects.equals(this.addressString, receiptRecognitionResult.addressString) && Objects.equals(this.phoneNumber, receiptRecognitionResult.phoneNumber) && Objects.equals(this.receiptItems, receiptRecognitionResult.receiptItems) && Objects.equals(this.receiptSubTotal, receiptRecognitionResult.receiptSubTotal) && Objects.equals(this.receiptTotal, receiptRecognitionResult.receiptTotal);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.timestamp, this.businessName, this.businessWebsite, this.addressString, this.phoneNumber, this.receiptItems, this.receiptSubTotal, this.receiptTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReceiptRecognitionResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    businessName: ").append(this.toIndentedString(this.businessName)).append("\n");
        sb.append("    businessWebsite: ").append(this.toIndentedString(this.businessWebsite)).append("\n");
        sb.append("    addressString: ").append(this.toIndentedString(this.addressString)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    receiptItems: ").append(this.toIndentedString(this.receiptItems)).append("\n");
        sb.append("    receiptSubTotal: ").append(this.toIndentedString(this.receiptSubTotal)).append("\n");
        sb.append("    receiptTotal: ").append(this.toIndentedString(this.receiptTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

