/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Receipt line item, comprised of a product or item and a price (if available)")
@JsonPropertyOrder(value={"ItemDescription", "ItemPrice"})
@JsonTypeName(value="ReceiptLineItem")
public class ReceiptLineItem {
    public static final String JSON_PROPERTY_ITEM_DESCRIPTION = "ItemDescription";
    private String itemDescription;
    public static final String JSON_PROPERTY_ITEM_PRICE = "ItemPrice";
    private Double itemPrice;

    public ReceiptLineItem itemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the item")
    @JsonProperty(value="ItemDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getItemDescription() {
        return this.itemDescription;
    }

    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
    }

    public ReceiptLineItem itemPrice(Double itemPrice) {
        this.itemPrice = itemPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Price of the item if available")
    @JsonProperty(value="ItemPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getItemPrice() {
        return this.itemPrice;
    }

    public void setItemPrice(Double itemPrice) {
        this.itemPrice = itemPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReceiptLineItem receiptLineItem = (ReceiptLineItem)o;
        return Objects.equals(this.itemDescription, receiptLineItem.itemDescription) && Objects.equals(this.itemPrice, receiptLineItem.itemPrice);
    }

    public int hashCode() {
        return Objects.hash(this.itemDescription, this.itemPrice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReceiptLineItem {\n");
        sb.append("    itemDescription: ").append(this.toIndentedString(this.itemDescription)).append("\n");
        sb.append("    itemPrice: ").append(this.toIndentedString(this.itemPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

