/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Output of a profanity analysis operation")
@JsonPropertyOrder(value={"Successful", "ProfanityScoreResult", "SentenceCount"})
@JsonTypeName(value="ProfanityAnalysisResponse")
public class ProfanityAnalysisResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_PROFANITY_SCORE_RESULT = "ProfanityScoreResult";
    private Double profanityScoreResult;
    public static final String JSON_PROPERTY_SENTENCE_COUNT = "SentenceCount";
    private Integer sentenceCount;

    public ProfanityAnalysisResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the profanity detection operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public ProfanityAnalysisResponse profanityScoreResult(Double profanityScoreResult) {
        this.profanityScoreResult = profanityScoreResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Profanity classification score between 0.0 and 1.0 where scores closer to zero have a low probability of being profane or contain obscene language, while scores close to 1.0 have a high probability of being profane or containing obscene language.  Values above 0.8 have a very high probability of being profane.")
    @JsonProperty(value="ProfanityScoreResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProfanityScoreResult() {
        return this.profanityScoreResult;
    }

    public void setProfanityScoreResult(Double profanityScoreResult) {
        this.profanityScoreResult = profanityScoreResult;
    }

    public ProfanityAnalysisResponse sentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of sentences in input text")
    @JsonProperty(value="SentenceCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSentenceCount() {
        return this.sentenceCount;
    }

    public void setSentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfanityAnalysisResponse profanityAnalysisResponse = (ProfanityAnalysisResponse)o;
        return Objects.equals(this.successful, profanityAnalysisResponse.successful) && Objects.equals(this.profanityScoreResult, profanityAnalysisResponse.profanityScoreResult) && Objects.equals(this.sentenceCount, profanityAnalysisResponse.sentenceCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.profanityScoreResult, this.sentenceCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProfanityAnalysisResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    profanityScoreResult: ").append(this.toIndentedString(this.profanityScoreResult)).append("\n");
        sb.append("    sentenceCount: ").append(this.toIndentedString(this.sentenceCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

