/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.OcrPhotoTextElement;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of an photo to words-with-location OCR operation")
@JsonPropertyOrder(value={"Successful", "TextElements", "DiagnosticImage"})
@JsonTypeName(value="PhotoToWordsWithLocationResult")
public class PhotoToWordsWithLocationResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_TEXT_ELEMENTS = "TextElements";
    private List<OcrPhotoTextElement> textElements = null;
    public static final String JSON_PROPERTY_DIAGNOSTIC_IMAGE = "DiagnosticImage";
    private byte[] diagnosticImage;

    public PhotoToWordsWithLocationResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public PhotoToWordsWithLocationResult textElements(List<OcrPhotoTextElement> textElements) {
        this.textElements = textElements;
        return this;
    }

    public PhotoToWordsWithLocationResult addTextElementsItem(OcrPhotoTextElement textElementsItem) {
        if (this.textElements == null) {
            this.textElements = new ArrayList<OcrPhotoTextElement>();
        }
        this.textElements.add(textElementsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Word elements in the image")
    @JsonProperty(value="TextElements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OcrPhotoTextElement> getTextElements() {
        return this.textElements;
    }

    public void setTextElements(List<OcrPhotoTextElement> textElements) {
        this.textElements = textElements;
    }

    public PhotoToWordsWithLocationResult diagnosticImage(byte[] diagnosticImage) {
        this.diagnosticImage = diagnosticImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Typically null.  To analyze OCR performance, enable diagnostic mode by adding the HTTP header \"DiagnosticMode\" with the value \"true\".  When this is true, a diagnostic image showing the details of the OCR result will be set in PNG format into DiagnosticImage.")
    @JsonProperty(value="DiagnosticImage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getDiagnosticImage() {
        return this.diagnosticImage;
    }

    public void setDiagnosticImage(byte[] diagnosticImage) {
        this.diagnosticImage = diagnosticImage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhotoToWordsWithLocationResult photoToWordsWithLocationResult = (PhotoToWordsWithLocationResult)o;
        return Objects.equals(this.successful, photoToWordsWithLocationResult.successful) && Objects.equals(this.textElements, photoToWordsWithLocationResult.textElements) && Arrays.equals(this.diagnosticImage, photoToWordsWithLocationResult.diagnosticImage);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.textElements, Arrays.hashCode(this.diagnosticImage));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhotoToWordsWithLocationResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    textElements: ").append(this.toIndentedString(this.textElements)).append("\n");
        sb.append("    diagnosticImage: ").append(this.toIndentedString(this.diagnosticImage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

