/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.Face;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A person identified in an image gender classification operation")
@JsonPropertyOrder(value={"FaceLocation", "GenderClassificationConfidence", "GenderClass"})
@JsonTypeName(value="PersonWithGender")
public class PersonWithGender {
    public static final String JSON_PROPERTY_FACE_LOCATION = "FaceLocation";
    private Face faceLocation;
    public static final String JSON_PROPERTY_GENDER_CLASSIFICATION_CONFIDENCE = "GenderClassificationConfidence";
    private Double genderClassificationConfidence;
    public static final String JSON_PROPERTY_GENDER_CLASS = "GenderClass";
    private String genderClass;

    public PersonWithGender faceLocation(Face faceLocation) {
        this.faceLocation = faceLocation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="FaceLocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Face getFaceLocation() {
        return this.faceLocation;
    }

    public void setFaceLocation(Face faceLocation) {
        this.faceLocation = faceLocation;
    }

    public PersonWithGender genderClassificationConfidence(Double genderClassificationConfidence) {
        this.genderClassificationConfidence = genderClassificationConfidence;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Confidence level of gender classification; possible values are between 0.0 and 1.0; higher is better, with values &gt; 0.50 being high confidence results")
    @JsonProperty(value="GenderClassificationConfidence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getGenderClassificationConfidence() {
        return this.genderClassificationConfidence;
    }

    public void setGenderClassificationConfidence(Double genderClassificationConfidence) {
        this.genderClassificationConfidence = genderClassificationConfidence;
    }

    public PersonWithGender genderClass(String genderClass) {
        this.genderClass = genderClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The person's identified gender; possible values are \"Male\", \"Female\" and \"Unknown\"")
    @JsonProperty(value="GenderClass")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGenderClass() {
        return this.genderClass;
    }

    public void setGenderClass(String genderClass) {
        this.genderClass = genderClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonWithGender personWithGender = (PersonWithGender)o;
        return Objects.equals(this.faceLocation, personWithGender.faceLocation) && Objects.equals(this.genderClassificationConfidence, personWithGender.genderClassificationConfidence) && Objects.equals(this.genderClass, personWithGender.genderClass);
    }

    public int hashCode() {
        return Objects.hash(this.faceLocation, this.genderClassificationConfidence, this.genderClass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PersonWithGender {\n");
        sb.append("    faceLocation: ").append(this.toIndentedString(this.faceLocation)).append("\n");
        sb.append("    genderClassificationConfidence: ").append(this.toIndentedString(this.genderClassificationConfidence)).append("\n");
        sb.append("    genderClass: ").append(this.toIndentedString(this.genderClass)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

