/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Field definition and value in the form")
@JsonPropertyOrder(value={"FieldName", "FieldType", "FieldValue", "FieldComboBoxSelectedIndex"})
@JsonTypeName(value="PdfFormField")
public class PdfFormField {
    public static final String JSON_PROPERTY_FIELD_NAME = "FieldName";
    private String fieldName;
    public static final String JSON_PROPERTY_FIELD_TYPE = "FieldType";
    private String fieldType;
    public static final String JSON_PROPERTY_FIELD_VALUE = "FieldValue";
    private String fieldValue;
    public static final String JSON_PROPERTY_FIELD_COMBO_BOX_SELECTED_INDEX = "FieldComboBoxSelectedIndex";
    private Integer fieldComboBoxSelectedIndex;

    public PdfFormField fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the form field")
    @JsonProperty(value="FieldName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public PdfFormField fieldType(String fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The data type of the field; possible values are Text (FieldValue will be a string), Checkbox (FieldValue can be \"true\" or \"false\"), ComboBox (FieldComboBoxSelectedIndex will also be populated), Other")
    @JsonProperty(value="FieldType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public PdfFormField fieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Value of the form field")
    @JsonProperty(value="FieldValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public PdfFormField fieldComboBoxSelectedIndex(Integer fieldComboBoxSelectedIndex) {
        this.fieldComboBoxSelectedIndex = fieldComboBoxSelectedIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Applies to ComboBox field types only; specifies the selected index of the combo box selection if available")
    @JsonProperty(value="FieldComboBoxSelectedIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFieldComboBoxSelectedIndex() {
        return this.fieldComboBoxSelectedIndex;
    }

    public void setFieldComboBoxSelectedIndex(Integer fieldComboBoxSelectedIndex) {
        this.fieldComboBoxSelectedIndex = fieldComboBoxSelectedIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfFormField pdfFormField = (PdfFormField)o;
        return Objects.equals(this.fieldName, pdfFormField.fieldName) && Objects.equals(this.fieldType, pdfFormField.fieldType) && Objects.equals(this.fieldValue, pdfFormField.fieldValue) && Objects.equals(this.fieldComboBoxSelectedIndex, pdfFormField.fieldComboBoxSelectedIndex);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.fieldType, this.fieldValue, this.fieldComboBoxSelectedIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfFormField {\n");
        sb.append("    fieldName: ").append(this.toIndentedString(this.fieldName)).append("\n");
        sb.append("    fieldType: ").append(this.toIndentedString(this.fieldType)).append("\n");
        sb.append("    fieldValue: ").append(this.toIndentedString(this.fieldValue)).append("\n");
        sb.append("    fieldComboBoxSelectedIndex: ").append(this.toIndentedString(this.fieldComboBoxSelectedIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

