/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to parse an address formatted as a string/free text into a structured address")
@JsonPropertyOrder(value={"AddressString", "CapitalizationMode"})
@JsonTypeName(value="ParseAddressRequest")
public class ParseAddressRequest {
    public static final String JSON_PROPERTY_ADDRESS_STRING = "AddressString";
    private String addressString;
    public static final String JSON_PROPERTY_CAPITALIZATION_MODE = "CapitalizationMode";
    private String capitalizationMode;

    public ParseAddressRequest addressString(String addressString) {
        this.addressString = addressString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A mailing address or street address formatted as a single text string; this will be parsed into its components")
    @JsonProperty(value="AddressString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddressString() {
        return this.addressString;
    }

    public void setAddressString(String addressString) {
        this.addressString = addressString;
    }

    public ParseAddressRequest capitalizationMode(String capitalizationMode) {
        this.capitalizationMode = capitalizationMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; indicates how the parsed output should be capitalized; default is Title Case; possible values are: \"Uppercase\" will set the capitalization to UPPER CASE; \"Lowercase\" will set the capitalization to lower case; \"Titlecase\" will set the capitalization to Title Case; and \"Originalcase\" will preserve the original casing as much as possible")
    @JsonProperty(value="CapitalizationMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCapitalizationMode() {
        return this.capitalizationMode;
    }

    public void setCapitalizationMode(String capitalizationMode) {
        this.capitalizationMode = capitalizationMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParseAddressRequest parseAddressRequest = (ParseAddressRequest)o;
        return Objects.equals(this.addressString, parseAddressRequest.addressString) && Objects.equals(this.capitalizationMode, parseAddressRequest.capitalizationMode);
    }

    public int hashCode() {
        return Objects.hash(this.addressString, this.capitalizationMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParseAddressRequest {\n");
        sb.append("    addressString: ").append(this.toIndentedString(this.addressString)).append("\n");
        sb.append("    capitalizationMode: ").append(this.toIndentedString(this.capitalizationMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

