/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Converted page as an image")
@JsonPropertyOrder(value={"Filename", "FileBytes"})
@JsonTypeName(value="PageConversionResult")
public class PageConversionResult {
    public static final String JSON_PROPERTY_FILENAME = "Filename";
    private String filename;
    public static final String JSON_PROPERTY_FILE_BYTES = "FileBytes";
    private byte[] fileBytes;

    public PageConversionResult filename(String filename) {
        this.filename = filename;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="File name of the image in the converted file format")
    @JsonProperty(value="Filename")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public PageConversionResult fileBytes(byte[] fileBytes) {
        this.fileBytes = fileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="File bytes (contents) of the image in converted file format")
    @JsonProperty(value="FileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getFileBytes() {
        return this.fileBytes;
    }

    public void setFileBytes(byte[] fileBytes) {
        this.fileBytes = fileBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageConversionResult pageConversionResult = (PageConversionResult)o;
        return Objects.equals(this.filename, pageConversionResult.filename) && Arrays.equals(this.fileBytes, pageConversionResult.fileBytes);
    }

    public int hashCode() {
        return Objects.hash(this.filename, Arrays.hashCode(this.fileBytes));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageConversionResult {\n");
        sb.append("    filename: ").append(this.toIndentedString(this.filename)).append("\n");
        sb.append("    fileBytes: ").append(this.toIndentedString(this.fileBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

