/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A single word in an OCR document")
@JsonPropertyOrder(value={"WordText", "LineNumber", "WordNumber", "XLeft", "YTop", "Width", "Height", "ConfidenceLevel", "BlockNumber", "ParagraphNumber", "PageNumber"})
@JsonTypeName(value="OcrWordElement")
public class OcrWordElement {
    public static final String JSON_PROPERTY_WORD_TEXT = "WordText";
    private String wordText;
    public static final String JSON_PROPERTY_LINE_NUMBER = "LineNumber";
    private Integer lineNumber;
    public static final String JSON_PROPERTY_WORD_NUMBER = "WordNumber";
    private Integer wordNumber;
    public static final String JSON_PROPERTY_XLEFT = "XLeft";
    private Integer xleft;
    public static final String JSON_PROPERTY_YTOP = "YTop";
    private Integer ytop;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Integer height;
    public static final String JSON_PROPERTY_CONFIDENCE_LEVEL = "ConfidenceLevel";
    private Double confidenceLevel;
    public static final String JSON_PROPERTY_BLOCK_NUMBER = "BlockNumber";
    private Integer blockNumber;
    public static final String JSON_PROPERTY_PARAGRAPH_NUMBER = "ParagraphNumber";
    private Integer paragraphNumber;
    public static final String JSON_PROPERTY_PAGE_NUMBER = "PageNumber";
    private Integer pageNumber;

    public OcrWordElement wordText(String wordText) {
        this.wordText = wordText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text of the word")
    @JsonProperty(value="WordText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWordText() {
        return this.wordText;
    }

    public void setWordText(String wordText) {
        this.wordText = wordText;
    }

    public OcrWordElement lineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Line number of the word")
    @JsonProperty(value="LineNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public OcrWordElement wordNumber(Integer wordNumber) {
        this.wordNumber = wordNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index of the word in the line")
    @JsonProperty(value="WordNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWordNumber() {
        return this.wordNumber;
    }

    public void setWordNumber(Integer wordNumber) {
        this.wordNumber = wordNumber;
    }

    public OcrWordElement xleft(Integer xleft) {
        this.xleft = xleft;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X location of the left edge of the word in pixels")
    @JsonProperty(value="XLeft")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getXleft() {
        return this.xleft;
    }

    public void setXleft(Integer xleft) {
        this.xleft = xleft;
    }

    public OcrWordElement ytop(Integer ytop) {
        this.ytop = ytop;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y location of the top edge of the word in pixels")
    @JsonProperty(value="YTop")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getYtop() {
        return this.ytop;
    }

    public void setYtop(Integer ytop) {
        this.ytop = ytop;
    }

    public OcrWordElement width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width of the word in pixels")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public OcrWordElement height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height of the word in pixels")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public OcrWordElement confidenceLevel(Double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Confidence level of the machine learning result; possible values are 0.0 (lowest accuracy) - 1.0 (highest accuracy)")
    @JsonProperty(value="ConfidenceLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public void setConfidenceLevel(Double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public OcrWordElement blockNumber(Integer blockNumber) {
        this.blockNumber = blockNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index of the containing block")
    @JsonProperty(value="BlockNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(Integer blockNumber) {
        this.blockNumber = blockNumber;
    }

    public OcrWordElement paragraphNumber(Integer paragraphNumber) {
        this.paragraphNumber = paragraphNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index of the containing paragraph")
    @JsonProperty(value="ParagraphNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getParagraphNumber() {
        return this.paragraphNumber;
    }

    public void setParagraphNumber(Integer paragraphNumber) {
        this.paragraphNumber = paragraphNumber;
    }

    public OcrWordElement pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index of the containing page")
    @JsonProperty(value="PageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OcrWordElement ocrWordElement = (OcrWordElement)o;
        return Objects.equals(this.wordText, ocrWordElement.wordText) && Objects.equals(this.lineNumber, ocrWordElement.lineNumber) && Objects.equals(this.wordNumber, ocrWordElement.wordNumber) && Objects.equals(this.xleft, ocrWordElement.xleft) && Objects.equals(this.ytop, ocrWordElement.ytop) && Objects.equals(this.width, ocrWordElement.width) && Objects.equals(this.height, ocrWordElement.height) && Objects.equals(this.confidenceLevel, ocrWordElement.confidenceLevel) && Objects.equals(this.blockNumber, ocrWordElement.blockNumber) && Objects.equals(this.paragraphNumber, ocrWordElement.paragraphNumber) && Objects.equals(this.pageNumber, ocrWordElement.pageNumber);
    }

    public int hashCode() {
        return Objects.hash(this.wordText, this.lineNumber, this.wordNumber, this.xleft, this.ytop, this.width, this.height, this.confidenceLevel, this.blockNumber, this.paragraphNumber, this.pageNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OcrWordElement {\n");
        sb.append("    wordText: ").append(this.toIndentedString(this.wordText)).append("\n");
        sb.append("    lineNumber: ").append(this.toIndentedString(this.lineNumber)).append("\n");
        sb.append("    wordNumber: ").append(this.toIndentedString(this.wordNumber)).append("\n");
        sb.append("    xleft: ").append(this.toIndentedString(this.xleft)).append("\n");
        sb.append("    ytop: ").append(this.toIndentedString(this.ytop)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    confidenceLevel: ").append(this.toIndentedString(this.confidenceLevel)).append("\n");
        sb.append("    blockNumber: ").append(this.toIndentedString(this.blockNumber)).append("\n");
        sb.append("    paragraphNumber: ").append(this.toIndentedString(this.paragraphNumber)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

