/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.OcrWordElement;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="OCR results of a page, including words of text and their location")
@JsonPropertyOrder(value={"PageNumber", "Successful", "Words"})
@JsonTypeName(value="OcrPageResultWithWordsWithLocation")
public class OcrPageResultWithWordsWithLocation {
    public static final String JSON_PROPERTY_PAGE_NUMBER = "PageNumber";
    private Integer pageNumber;
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_WORDS = "Words";
    private List<OcrWordElement> words = null;

    public OcrPageResultWithWordsWithLocation pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Page number of the page that was OCR-ed, starting with 1 for the first page in the PDF file")
    @JsonProperty(value="PageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public OcrPageResultWithWordsWithLocation successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public OcrPageResultWithWordsWithLocation words(List<OcrWordElement> words) {
        this.words = words;
        return this;
    }

    public OcrPageResultWithWordsWithLocation addWordsItem(OcrWordElement wordsItem) {
        if (this.words == null) {
            this.words = new ArrayList<OcrWordElement>();
        }
        this.words.add(wordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Word elements in the image")
    @JsonProperty(value="Words")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OcrWordElement> getWords() {
        return this.words;
    }

    public void setWords(List<OcrWordElement> words) {
        this.words = words;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OcrPageResultWithWordsWithLocation ocrPageResultWithWordsWithLocation = (OcrPageResultWithWordsWithLocation)o;
        return Objects.equals(this.pageNumber, ocrPageResultWithWordsWithLocation.pageNumber) && Objects.equals(this.successful, ocrPageResultWithWordsWithLocation.successful) && Objects.equals(this.words, ocrPageResultWithWordsWithLocation.words);
    }

    public int hashCode() {
        return Objects.hash(this.pageNumber, this.successful, this.words);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OcrPageResultWithWordsWithLocation {\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    words: ").append(this.toIndentedString(this.words)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

