/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.OcrWordElement;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A contiguous line of text in an OCR document")
@JsonPropertyOrder(value={"LineText", "Words"})
@JsonTypeName(value="OcrLineElement")
public class OcrLineElement {
    public static final String JSON_PROPERTY_LINE_TEXT = "LineText";
    private String lineText;
    public static final String JSON_PROPERTY_WORDS = "Words";
    private List<OcrWordElement> words = null;

    public OcrLineElement lineText(String lineText) {
        this.lineText = lineText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text of the line")
    @JsonProperty(value="LineText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLineText() {
        return this.lineText;
    }

    public void setLineText(String lineText) {
        this.lineText = lineText;
    }

    public OcrLineElement words(List<OcrWordElement> words) {
        this.words = words;
        return this;
    }

    public OcrLineElement addWordsItem(OcrWordElement wordsItem) {
        if (this.words == null) {
            this.words = new ArrayList<OcrWordElement>();
        }
        this.words.add(wordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Word objects in the line")
    @JsonProperty(value="Words")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OcrWordElement> getWords() {
        return this.words;
    }

    public void setWords(List<OcrWordElement> words) {
        this.words = words;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OcrLineElement ocrLineElement = (OcrLineElement)o;
        return Objects.equals(this.lineText, ocrLineElement.lineText) && Objects.equals(this.words, ocrLineElement.words);
    }

    public int hashCode() {
        return Objects.hash(this.lineText, this.words);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OcrLineElement {\n");
        sb.append("    lineText: ").append(this.toIndentedString(this.lineText)).append("\n");
        sb.append("    words: ").append(this.toIndentedString(this.words)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

