/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An individual frame scanned for NSFW content")
@JsonPropertyOrder(value={"FrameNumber", "TimeStamp", "Content", "ClassificationResult", "Score"})
@JsonTypeName(value="NsfwScannedFrame")
public class NsfwScannedFrame {
    public static final String JSON_PROPERTY_FRAME_NUMBER = "FrameNumber";
    private Integer frameNumber;
    public static final String JSON_PROPERTY_TIME_STAMP = "TimeStamp";
    private String timeStamp;
    public static final String JSON_PROPERTY_CONTENT = "Content";
    private byte[] content;
    public static final String JSON_PROPERTY_CLASSIFICATION_RESULT = "ClassificationResult";
    private String classificationResult;
    public static final String JSON_PROPERTY_SCORE = "Score";
    private Double score;

    public NsfwScannedFrame frameNumber(Integer frameNumber) {
        this.frameNumber = frameNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of the current frame")
    @JsonProperty(value="FrameNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFrameNumber() {
        return this.frameNumber;
    }

    public void setFrameNumber(Integer frameNumber) {
        this.frameNumber = frameNumber;
    }

    public NsfwScannedFrame timeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The playback time of the current frame")
    @JsonProperty(value="TimeStamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public NsfwScannedFrame content(byte[] content) {
        this.content = content;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The still frame in PNG format as a byte array")
    @JsonProperty(value="Content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public NsfwScannedFrame classificationResult(String classificationResult) {
        this.classificationResult = classificationResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The NSFW classification of the still frame")
    @JsonProperty(value="ClassificationResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClassificationResult() {
        return this.classificationResult;
    }

    public void setClassificationResult(String classificationResult) {
        this.classificationResult = classificationResult;
    }

    public NsfwScannedFrame score(Double score) {
        this.score = score;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The NSFW score of the current frame")
    @JsonProperty(value="Score")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NsfwScannedFrame nsfwScannedFrame = (NsfwScannedFrame)o;
        return Objects.equals(this.frameNumber, nsfwScannedFrame.frameNumber) && Objects.equals(this.timeStamp, nsfwScannedFrame.timeStamp) && Arrays.equals(this.content, nsfwScannedFrame.content) && Objects.equals(this.classificationResult, nsfwScannedFrame.classificationResult) && Objects.equals(this.score, nsfwScannedFrame.score);
    }

    public int hashCode() {
        return Objects.hash(this.frameNumber, this.timeStamp, Arrays.hashCode(this.content), this.classificationResult, this.score);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NsfwScannedFrame {\n");
        sb.append("    frameNumber: ").append(this.toIndentedString(this.frameNumber)).append("\n");
        sb.append("    timeStamp: ").append(this.toIndentedString(this.timeStamp)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    classificationResult: ").append(this.toIndentedString(this.classificationResult)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

