/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.SingleReplaceString;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a multiple string replacement request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "ReplaceStrings"})
@JsonTypeName(value="MultiReplaceStringRequest")
public class MultiReplaceStringRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_REPLACE_STRINGS = "ReplaceStrings";
    private List<SingleReplaceString> replaceStrings = null;

    public MultiReplaceStringRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public MultiReplaceStringRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public MultiReplaceStringRequest replaceStrings(List<SingleReplaceString> replaceStrings) {
        this.replaceStrings = replaceStrings;
        return this;
    }

    public MultiReplaceStringRequest addReplaceStringsItem(SingleReplaceString replaceStringsItem) {
        if (this.replaceStrings == null) {
            this.replaceStrings = new ArrayList<SingleReplaceString>();
        }
        this.replaceStrings.add(replaceStringsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of individual string replacement requests")
    @JsonProperty(value="ReplaceStrings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SingleReplaceString> getReplaceStrings() {
        return this.replaceStrings;
    }

    public void setReplaceStrings(List<SingleReplaceString> replaceStrings) {
        this.replaceStrings = replaceStrings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiReplaceStringRequest multiReplaceStringRequest = (MultiReplaceStringRequest)o;
        return Arrays.equals(this.inputFileBytes, multiReplaceStringRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, multiReplaceStringRequest.inputFileUrl) && Objects.equals(this.replaceStrings, multiReplaceStringRequest.replaceStrings);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.replaceStrings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultiReplaceStringRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    replaceStrings: ").append(this.toIndentedString(this.replaceStrings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

