/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.MsgAttachment;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of converting an MSG file to HTML string")
@JsonPropertyOrder(value={"Successful", "Content", "Body", "From", "To", "Cc", "ReceivedTime", "Subject", "Attachments"})
@JsonTypeName(value="MsgToHtmlResult")
public class MsgToHtmlResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_CONTENT = "Content";
    private String content;
    public static final String JSON_PROPERTY_BODY = "Body";
    private String body;
    public static final String JSON_PROPERTY_FROM = "From";
    private String from;
    public static final String JSON_PROPERTY_TO = "To";
    private String to;
    public static final String JSON_PROPERTY_CC = "Cc";
    private String cc;
    public static final String JSON_PROPERTY_RECEIVED_TIME = "ReceivedTime";
    private String receivedTime;
    public static final String JSON_PROPERTY_SUBJECT = "Subject";
    private String subject;
    public static final String JSON_PROPERTY_ATTACHMENTS = "Attachments";
    private List<MsgAttachment> attachments = null;

    public MsgToHtmlResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public MsgToHtmlResult content(String content) {
        this.content = content;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An HTML string version of the MSG file")
    @JsonProperty(value="Content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public MsgToHtmlResult body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The main body of the MSG file's email as an HTML string")
    @JsonProperty(value="Body")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public MsgToHtmlResult from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The From sender of the MSG file's email")
    @JsonProperty(value="From")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public MsgToHtmlResult to(String to) {
        this.to = to;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The To recipients of the MSG file's email")
    @JsonProperty(value="To")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public MsgToHtmlResult cc(String cc) {
        this.cc = cc;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The CC recipients of the MSG file's email")
    @JsonProperty(value="Cc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public MsgToHtmlResult receivedTime(String receivedTime) {
        this.receivedTime = receivedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time that the MSG file's email was received")
    @JsonProperty(value="ReceivedTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReceivedTime() {
        return this.receivedTime;
    }

    public void setReceivedTime(String receivedTime) {
        this.receivedTime = receivedTime;
    }

    public MsgToHtmlResult subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The subject of the MSG file's email")
    @JsonProperty(value="Subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MsgToHtmlResult attachments(List<MsgAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public MsgToHtmlResult addAttachmentsItem(MsgAttachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<MsgAttachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of all attachments for the MSG file")
    @JsonProperty(value="Attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MsgAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<MsgAttachment> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MsgToHtmlResult msgToHtmlResult = (MsgToHtmlResult)o;
        return Objects.equals(this.successful, msgToHtmlResult.successful) && Objects.equals(this.content, msgToHtmlResult.content) && Objects.equals(this.body, msgToHtmlResult.body) && Objects.equals(this.from, msgToHtmlResult.from) && Objects.equals(this.to, msgToHtmlResult.to) && Objects.equals(this.cc, msgToHtmlResult.cc) && Objects.equals(this.receivedTime, msgToHtmlResult.receivedTime) && Objects.equals(this.subject, msgToHtmlResult.subject) && Objects.equals(this.attachments, msgToHtmlResult.attachments);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.content, this.body, this.from, this.to, this.cc, this.receivedTime, this.subject, this.attachments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsgToHtmlResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    receivedTime: ").append(this.toIndentedString(this.receivedTime)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

