/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of retrieving information about a video or audio file")
@JsonPropertyOrder(value={"Successful", "FileFormat", "FileFormatFull", "ValidFileFormats", "Width", "Height", "Size", "BitRate", "Duration", "StartTime"})
@JsonTypeName(value="MediaInformation")
public class MediaInformation {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_FILE_FORMAT = "FileFormat";
    private String fileFormat;
    public static final String JSON_PROPERTY_FILE_FORMAT_FULL = "FileFormatFull";
    private String fileFormatFull;
    public static final String JSON_PROPERTY_VALID_FILE_FORMATS = "ValidFileFormats";
    private List<String> validFileFormats = null;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Integer height;
    public static final String JSON_PROPERTY_SIZE = "Size";
    private Integer size;
    public static final String JSON_PROPERTY_BIT_RATE = "BitRate";
    private Integer bitRate;
    public static final String JSON_PROPERTY_DURATION = "Duration";
    private Double duration;
    public static final String JSON_PROPERTY_START_TIME = "StartTime";
    private Double startTime;

    public MediaInformation successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public MediaInformation fileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The file's short format name")
    @JsonProperty(value="FileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public MediaInformation fileFormatFull(String fileFormatFull) {
        this.fileFormatFull = fileFormatFull;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The file's full format name")
    @JsonProperty(value="FileFormatFull")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileFormatFull() {
        return this.fileFormatFull;
    }

    public void setFileFormatFull(String fileFormatFull) {
        this.fileFormatFull = fileFormatFull;
    }

    public MediaInformation validFileFormats(List<String> validFileFormats) {
        this.validFileFormats = validFileFormats;
        return this;
    }

    public MediaInformation addValidFileFormatsItem(String validFileFormatsItem) {
        if (this.validFileFormats == null) {
            this.validFileFormats = new ArrayList<String>();
        }
        this.validFileFormats.add(validFileFormatsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of the file's valid formats")
    @JsonProperty(value="ValidFileFormats")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getValidFileFormats() {
        return this.validFileFormats;
    }

    public void setValidFileFormats(List<String> validFileFormats) {
        this.validFileFormats = validFileFormats;
    }

    public MediaInformation width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The video's width, if file is a video")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public MediaInformation height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The video's height, if file is a video")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public MediaInformation size(Integer size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The file's size in bytes")
    @JsonProperty(value="Size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public MediaInformation bitRate(Integer bitRate) {
        this.bitRate = bitRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The file's bit rate")
    @JsonProperty(value="BitRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(Integer bitRate) {
        this.bitRate = bitRate;
    }

    public MediaInformation duration(Double duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The file's duration in seconds")
    @JsonProperty(value="Duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public MediaInformation startTime(Double startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The file's media start time")
    @JsonProperty(value="StartTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Double startTime) {
        this.startTime = startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaInformation mediaInformation = (MediaInformation)o;
        return Objects.equals(this.successful, mediaInformation.successful) && Objects.equals(this.fileFormat, mediaInformation.fileFormat) && Objects.equals(this.fileFormatFull, mediaInformation.fileFormatFull) && Objects.equals(this.validFileFormats, mediaInformation.validFileFormats) && Objects.equals(this.width, mediaInformation.width) && Objects.equals(this.height, mediaInformation.height) && Objects.equals(this.size, mediaInformation.size) && Objects.equals(this.bitRate, mediaInformation.bitRate) && Objects.equals(this.duration, mediaInformation.duration) && Objects.equals(this.startTime, mediaInformation.startTime);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.fileFormat, this.fileFormatFull, this.validFileFormats, this.width, this.height, this.size, this.bitRate, this.duration, this.startTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaInformation {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    fileFormat: ").append(this.toIndentedString(this.fileFormat)).append("\n");
        sb.append("    fileFormatFull: ").append(this.toIndentedString(this.fileFormatFull)).append("\n");
        sb.append("    validFileFormats: ").append(this.toIndentedString(this.validFileFormats)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    bitRate: ").append(this.toIndentedString(this.bitRate)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

