/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to enumerate settings")
@JsonPropertyOrder(value={"BucketID", "BucketSecretKey"})
@JsonTypeName(value="ListSettingsRequest")
public class ListSettingsRequest {
    public static final String JSON_PROPERTY_BUCKET_I_D = "BucketID";
    private String bucketID;
    public static final String JSON_PROPERTY_BUCKET_SECRET_KEY = "BucketSecretKey";
    private String bucketSecretKey;

    public ListSettingsRequest bucketID(String bucketID) {
        this.bucketID = bucketID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BucketID of the bucket to enumerate the settings of; you can create a bucket by navigating to account.cloudmersive.com, clicking on Settings &gt; API Configuration &gt; Create Bucket")
    @JsonProperty(value="BucketID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBucketID() {
        return this.bucketID;
    }

    public void setBucketID(String bucketID) {
        this.bucketID = bucketID;
    }

    public ListSettingsRequest bucketSecretKey(String bucketSecretKey) {
        this.bucketSecretKey = bucketSecretKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SecretKey of the bucket enumerate the settings of; you can create a bucket by navigating to account.cloudmersive.com, clicking on Settings &gt; API Configuration &gt; Create Bucket")
    @JsonProperty(value="BucketSecretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBucketSecretKey() {
        return this.bucketSecretKey;
    }

    public void setBucketSecretKey(String bucketSecretKey) {
        this.bucketSecretKey = bucketSecretKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListSettingsRequest listSettingsRequest = (ListSettingsRequest)o;
        return Objects.equals(this.bucketID, listSettingsRequest.bucketID) && Objects.equals(this.bucketSecretKey, listSettingsRequest.bucketSecretKey);
    }

    public int hashCode() {
        return Objects.hash(this.bucketID, this.bucketSecretKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListSettingsRequest {\n");
        sb.append("    bucketID: ").append(this.toIndentedString(this.bucketID)).append("\n");
        sb.append("    bucketSecretKey: ").append(this.toIndentedString(this.bucketSecretKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

