/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of the lead enrichment process")
@JsonPropertyOrder(value={"Successful", "LeadType", "ContactBusinessEmail", "ContactFirstName", "ContactLastName", "ContactGender", "CompanyName", "CompanyDomainName", "CompanyHouseNumber", "CompanyStreet", "CompanyCity", "CompanyStateOrProvince", "CompanyPostalCode", "CompanyCountry", "CompanyCountryCode", "CompanyTelephone", "CompanyVATNumber", "EmployeeCount"})
@JsonTypeName(value="LeadEnrichmentResponse")
public class LeadEnrichmentResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_LEAD_TYPE = "LeadType";
    private String leadType;
    public static final String JSON_PROPERTY_CONTACT_BUSINESS_EMAIL = "ContactBusinessEmail";
    private String contactBusinessEmail;
    public static final String JSON_PROPERTY_CONTACT_FIRST_NAME = "ContactFirstName";
    private String contactFirstName;
    public static final String JSON_PROPERTY_CONTACT_LAST_NAME = "ContactLastName";
    private String contactLastName;
    public static final String JSON_PROPERTY_CONTACT_GENDER = "ContactGender";
    private String contactGender;
    public static final String JSON_PROPERTY_COMPANY_NAME = "CompanyName";
    private String companyName;
    public static final String JSON_PROPERTY_COMPANY_DOMAIN_NAME = "CompanyDomainName";
    private String companyDomainName;
    public static final String JSON_PROPERTY_COMPANY_HOUSE_NUMBER = "CompanyHouseNumber";
    private String companyHouseNumber;
    public static final String JSON_PROPERTY_COMPANY_STREET = "CompanyStreet";
    private String companyStreet;
    public static final String JSON_PROPERTY_COMPANY_CITY = "CompanyCity";
    private String companyCity;
    public static final String JSON_PROPERTY_COMPANY_STATE_OR_PROVINCE = "CompanyStateOrProvince";
    private String companyStateOrProvince;
    public static final String JSON_PROPERTY_COMPANY_POSTAL_CODE = "CompanyPostalCode";
    private String companyPostalCode;
    public static final String JSON_PROPERTY_COMPANY_COUNTRY = "CompanyCountry";
    private String companyCountry;
    public static final String JSON_PROPERTY_COMPANY_COUNTRY_CODE = "CompanyCountryCode";
    private String companyCountryCode;
    public static final String JSON_PROPERTY_COMPANY_TELEPHONE = "CompanyTelephone";
    private String companyTelephone;
    public static final String JSON_PROPERTY_COMPANY_V_A_T_NUMBER = "CompanyVATNumber";
    private String companyVATNumber;
    public static final String JSON_PROPERTY_EMPLOYEE_COUNT = "EmployeeCount";
    private Integer employeeCount;

    public LeadEnrichmentResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public LeadEnrichmentResponse leadType(String leadType) {
        this.leadType = leadType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the lead; possible types are Junk (a single individual using a disposable/throwaway email address); Individual (a single individual, typically a consumer, not purchasing on behalf of a business); SmallBusiness (a small business, typically with fewer than 100 employees); MediumBusiness (a medium business, larger than 100 employees but fewer than 1000 employees); Enterprise (a large business with greater than 1000 employees); Business (a business customer of unknown size)")
    @JsonProperty(value="LeadType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLeadType() {
        return this.leadType;
    }

    public void setLeadType(String leadType) {
        this.leadType = leadType;
    }

    public LeadEnrichmentResponse contactBusinessEmail(String contactBusinessEmail) {
        this.contactBusinessEmail = contactBusinessEmail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The person's business email address for the lead")
    @JsonProperty(value="ContactBusinessEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContactBusinessEmail() {
        return this.contactBusinessEmail;
    }

    public void setContactBusinessEmail(String contactBusinessEmail) {
        this.contactBusinessEmail = contactBusinessEmail;
    }

    public LeadEnrichmentResponse contactFirstName(String contactFirstName) {
        this.contactFirstName = contactFirstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The person's first name for the lead")
    @JsonProperty(value="ContactFirstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContactFirstName() {
        return this.contactFirstName;
    }

    public void setContactFirstName(String contactFirstName) {
        this.contactFirstName = contactFirstName;
    }

    public LeadEnrichmentResponse contactLastName(String contactLastName) {
        this.contactLastName = contactLastName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The person's last name for the lead")
    @JsonProperty(value="ContactLastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContactLastName() {
        return this.contactLastName;
    }

    public void setContactLastName(String contactLastName) {
        this.contactLastName = contactLastName;
    }

    public LeadEnrichmentResponse contactGender(String contactGender) {
        this.contactGender = contactGender;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Gender for contact name; possible values are Male, Female, and Neutral (can be applied to Male or Female).  Requires ContactFirstName.")
    @JsonProperty(value="ContactGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContactGender() {
        return this.contactGender;
    }

    public void setContactGender(String contactGender) {
        this.contactGender = contactGender;
    }

    public LeadEnrichmentResponse companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the company for the lead")
    @JsonProperty(value="CompanyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public LeadEnrichmentResponse companyDomainName(String companyDomainName) {
        this.companyDomainName = companyDomainName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Domain name / website for the lead")
    @JsonProperty(value="CompanyDomainName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyDomainName() {
        return this.companyDomainName;
    }

    public void setCompanyDomainName(String companyDomainName) {
        this.companyDomainName = companyDomainName;
    }

    public LeadEnrichmentResponse companyHouseNumber(String companyHouseNumber) {
        this.companyHouseNumber = companyHouseNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="House number of the address of the company for the lead")
    @JsonProperty(value="CompanyHouseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyHouseNumber() {
        return this.companyHouseNumber;
    }

    public void setCompanyHouseNumber(String companyHouseNumber) {
        this.companyHouseNumber = companyHouseNumber;
    }

    public LeadEnrichmentResponse companyStreet(String companyStreet) {
        this.companyStreet = companyStreet;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Street name of the address of the company for the lead")
    @JsonProperty(value="CompanyStreet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyStreet() {
        return this.companyStreet;
    }

    public void setCompanyStreet(String companyStreet) {
        this.companyStreet = companyStreet;
    }

    public LeadEnrichmentResponse companyCity(String companyCity) {
        this.companyCity = companyCity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="City of the address of the company for the lead")
    @JsonProperty(value="CompanyCity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyCity() {
        return this.companyCity;
    }

    public void setCompanyCity(String companyCity) {
        this.companyCity = companyCity;
    }

    public LeadEnrichmentResponse companyStateOrProvince(String companyStateOrProvince) {
        this.companyStateOrProvince = companyStateOrProvince;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State or Province of the address of the company for the lead")
    @JsonProperty(value="CompanyStateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyStateOrProvince() {
        return this.companyStateOrProvince;
    }

    public void setCompanyStateOrProvince(String companyStateOrProvince) {
        this.companyStateOrProvince = companyStateOrProvince;
    }

    public LeadEnrichmentResponse companyPostalCode(String companyPostalCode) {
        this.companyPostalCode = companyPostalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Postal Code of the address of the company for the lead")
    @JsonProperty(value="CompanyPostalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyPostalCode() {
        return this.companyPostalCode;
    }

    public void setCompanyPostalCode(String companyPostalCode) {
        this.companyPostalCode = companyPostalCode;
    }

    public LeadEnrichmentResponse companyCountry(String companyCountry) {
        this.companyCountry = companyCountry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Country Name of the address of the company for the lead")
    @JsonProperty(value="CompanyCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyCountry() {
        return this.companyCountry;
    }

    public void setCompanyCountry(String companyCountry) {
        this.companyCountry = companyCountry;
    }

    public LeadEnrichmentResponse companyCountryCode(String companyCountryCode) {
        this.companyCountryCode = companyCountryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Country Code (2-letter ISO 3166-1) of the address of the company for the lead")
    @JsonProperty(value="CompanyCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyCountryCode() {
        return this.companyCountryCode;
    }

    public void setCompanyCountryCode(String companyCountryCode) {
        this.companyCountryCode = companyCountryCode;
    }

    public LeadEnrichmentResponse companyTelephone(String companyTelephone) {
        this.companyTelephone = companyTelephone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Telephone of the company office for the lead")
    @JsonProperty(value="CompanyTelephone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyTelephone() {
        return this.companyTelephone;
    }

    public void setCompanyTelephone(String companyTelephone) {
        this.companyTelephone = companyTelephone;
    }

    public LeadEnrichmentResponse companyVATNumber(String companyVATNumber) {
        this.companyVATNumber = companyVATNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VAT number of the company for the lead")
    @JsonProperty(value="CompanyVATNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyVATNumber() {
        return this.companyVATNumber;
    }

    public void setCompanyVATNumber(String companyVATNumber) {
        this.companyVATNumber = companyVATNumber;
    }

    public LeadEnrichmentResponse employeeCount(Integer employeeCount) {
        this.employeeCount = employeeCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count of employees at the company (estimated), if available")
    @JsonProperty(value="EmployeeCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getEmployeeCount() {
        return this.employeeCount;
    }

    public void setEmployeeCount(Integer employeeCount) {
        this.employeeCount = employeeCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeadEnrichmentResponse leadEnrichmentResponse = (LeadEnrichmentResponse)o;
        return Objects.equals(this.successful, leadEnrichmentResponse.successful) && Objects.equals(this.leadType, leadEnrichmentResponse.leadType) && Objects.equals(this.contactBusinessEmail, leadEnrichmentResponse.contactBusinessEmail) && Objects.equals(this.contactFirstName, leadEnrichmentResponse.contactFirstName) && Objects.equals(this.contactLastName, leadEnrichmentResponse.contactLastName) && Objects.equals(this.contactGender, leadEnrichmentResponse.contactGender) && Objects.equals(this.companyName, leadEnrichmentResponse.companyName) && Objects.equals(this.companyDomainName, leadEnrichmentResponse.companyDomainName) && Objects.equals(this.companyHouseNumber, leadEnrichmentResponse.companyHouseNumber) && Objects.equals(this.companyStreet, leadEnrichmentResponse.companyStreet) && Objects.equals(this.companyCity, leadEnrichmentResponse.companyCity) && Objects.equals(this.companyStateOrProvince, leadEnrichmentResponse.companyStateOrProvince) && Objects.equals(this.companyPostalCode, leadEnrichmentResponse.companyPostalCode) && Objects.equals(this.companyCountry, leadEnrichmentResponse.companyCountry) && Objects.equals(this.companyCountryCode, leadEnrichmentResponse.companyCountryCode) && Objects.equals(this.companyTelephone, leadEnrichmentResponse.companyTelephone) && Objects.equals(this.companyVATNumber, leadEnrichmentResponse.companyVATNumber) && Objects.equals(this.employeeCount, leadEnrichmentResponse.employeeCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.leadType, this.contactBusinessEmail, this.contactFirstName, this.contactLastName, this.contactGender, this.companyName, this.companyDomainName, this.companyHouseNumber, this.companyStreet, this.companyCity, this.companyStateOrProvince, this.companyPostalCode, this.companyCountry, this.companyCountryCode, this.companyTelephone, this.companyVATNumber, this.employeeCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LeadEnrichmentResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    leadType: ").append(this.toIndentedString(this.leadType)).append("\n");
        sb.append("    contactBusinessEmail: ").append(this.toIndentedString(this.contactBusinessEmail)).append("\n");
        sb.append("    contactFirstName: ").append(this.toIndentedString(this.contactFirstName)).append("\n");
        sb.append("    contactLastName: ").append(this.toIndentedString(this.contactLastName)).append("\n");
        sb.append("    contactGender: ").append(this.toIndentedString(this.contactGender)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    companyDomainName: ").append(this.toIndentedString(this.companyDomainName)).append("\n");
        sb.append("    companyHouseNumber: ").append(this.toIndentedString(this.companyHouseNumber)).append("\n");
        sb.append("    companyStreet: ").append(this.toIndentedString(this.companyStreet)).append("\n");
        sb.append("    companyCity: ").append(this.toIndentedString(this.companyCity)).append("\n");
        sb.append("    companyStateOrProvince: ").append(this.toIndentedString(this.companyStateOrProvince)).append("\n");
        sb.append("    companyPostalCode: ").append(this.toIndentedString(this.companyPostalCode)).append("\n");
        sb.append("    companyCountry: ").append(this.toIndentedString(this.companyCountry)).append("\n");
        sb.append("    companyCountryCode: ").append(this.toIndentedString(this.companyCountryCode)).append("\n");
        sb.append("    companyTelephone: ").append(this.toIndentedString(this.companyTelephone)).append("\n");
        sb.append("    companyVATNumber: ").append(this.toIndentedString(this.companyVATNumber)).append("\n");
        sb.append("    employeeCount: ").append(this.toIndentedString(this.employeeCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

