/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Output of a language translation operation")
@JsonPropertyOrder(value={"Successful", "TranslatedTextResult", "SentenceCount"})
@JsonTypeName(value="LanguageTranslationResponse")
public class LanguageTranslationResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_TRANSLATED_TEXT_RESULT = "TranslatedTextResult";
    private String translatedTextResult;
    public static final String JSON_PROPERTY_SENTENCE_COUNT = "SentenceCount";
    private Integer sentenceCount;

    public LanguageTranslationResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the language detection operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public LanguageTranslationResponse translatedTextResult(String translatedTextResult) {
        this.translatedTextResult = translatedTextResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Translated text in target language")
    @JsonProperty(value="TranslatedTextResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTranslatedTextResult() {
        return this.translatedTextResult;
    }

    public void setTranslatedTextResult(String translatedTextResult) {
        this.translatedTextResult = translatedTextResult;
    }

    public LanguageTranslationResponse sentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of sentences in input text")
    @JsonProperty(value="SentenceCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSentenceCount() {
        return this.sentenceCount;
    }

    public void setSentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageTranslationResponse languageTranslationResponse = (LanguageTranslationResponse)o;
        return Objects.equals(this.successful, languageTranslationResponse.successful) && Objects.equals(this.translatedTextResult, languageTranslationResponse.translatedTextResult) && Objects.equals(this.sentenceCount, languageTranslationResponse.sentenceCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.translatedTextResult, this.sentenceCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LanguageTranslationResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    translatedTextResult: ").append(this.toIndentedString(this.translatedTextResult)).append("\n");
        sb.append("    sentenceCount: ").append(this.toIndentedString(this.sentenceCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

