/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.XlsxWorksheet;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Insert Worksheets request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "WorksheetToInsert"})
@JsonTypeName(value="InsertXlsxWorksheetRequest")
public class InsertXlsxWorksheetRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_WORKSHEET_TO_INSERT = "WorksheetToInsert";
    private XlsxWorksheet worksheetToInsert;

    public InsertXlsxWorksheetRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public InsertXlsxWorksheetRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public InsertXlsxWorksheetRequest worksheetToInsert(XlsxWorksheet worksheetToInsert) {
        this.worksheetToInsert = worksheetToInsert;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="WorksheetToInsert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public XlsxWorksheet getWorksheetToInsert() {
        return this.worksheetToInsert;
    }

    public void setWorksheetToInsert(XlsxWorksheet worksheetToInsert) {
        this.worksheetToInsert = worksheetToInsert;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertXlsxWorksheetRequest insertXlsxWorksheetRequest = (InsertXlsxWorksheetRequest)o;
        return Arrays.equals(this.inputFileBytes, insertXlsxWorksheetRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, insertXlsxWorksheetRequest.inputFileUrl) && Objects.equals(this.worksheetToInsert, insertXlsxWorksheetRequest.worksheetToInsert);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.worksheetToInsert);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsertXlsxWorksheetRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    worksheetToInsert: ").append(this.toIndentedString(this.worksheetToInsert)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

