/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxTableRow;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Insert Table Row request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "RowToInsert", "InsertPlacement", "ExistingTablePath"})
@JsonTypeName(value="InsertDocxTableRowRequest")
public class InsertDocxTableRowRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_ROW_TO_INSERT = "RowToInsert";
    private DocxTableRow rowToInsert;
    public static final String JSON_PROPERTY_INSERT_PLACEMENT = "InsertPlacement";
    private String insertPlacement;
    public static final String JSON_PROPERTY_EXISTING_TABLE_PATH = "ExistingTablePath";
    private String existingTablePath;

    public InsertDocxTableRowRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public InsertDocxTableRowRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public InsertDocxTableRowRequest rowToInsert(DocxTableRow rowToInsert) {
        this.rowToInsert = rowToInsert;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="RowToInsert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DocxTableRow getRowToInsert() {
        return this.rowToInsert;
    }

    public void setRowToInsert(DocxTableRow rowToInsert) {
        this.rowToInsert = rowToInsert;
    }

    public InsertDocxTableRowRequest insertPlacement(String insertPlacement) {
        this.insertPlacement = insertPlacement;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; default is TableEnd.  Placement Type of the insert; possible values are: TableStart (very beginning of the table), TableEnd (very end of the document), or a 0-based row index number as an integer, 0 being the first row in the table, 1 being the second row in the table, 2 being the third row in the table, etc. to insert this row after")
    @JsonProperty(value="InsertPlacement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInsertPlacement() {
        return this.insertPlacement;
    }

    public void setInsertPlacement(String insertPlacement) {
        this.insertPlacement = insertPlacement;
    }

    public InsertDocxTableRowRequest existingTablePath(String existingTablePath) {
        this.existingTablePath = existingTablePath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required; the path to the existing table to modify")
    @JsonProperty(value="ExistingTablePath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExistingTablePath() {
        return this.existingTablePath;
    }

    public void setExistingTablePath(String existingTablePath) {
        this.existingTablePath = existingTablePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertDocxTableRowRequest insertDocxTableRowRequest = (InsertDocxTableRowRequest)o;
        return Arrays.equals(this.inputFileBytes, insertDocxTableRowRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, insertDocxTableRowRequest.inputFileUrl) && Objects.equals(this.rowToInsert, insertDocxTableRowRequest.rowToInsert) && Objects.equals(this.insertPlacement, insertDocxTableRowRequest.insertPlacement) && Objects.equals(this.existingTablePath, insertDocxTableRowRequest.existingTablePath);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.rowToInsert, this.insertPlacement, this.existingTablePath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsertDocxTableRowRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    rowToInsert: ").append(this.toIndentedString(this.rowToInsert)).append("\n");
        sb.append("    insertPlacement: ").append(this.toIndentedString(this.insertPlacement)).append("\n");
        sb.append("    existingTablePath: ").append(this.toIndentedString(this.existingTablePath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

