/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.OcrLineElement;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of an image to lines-with-location OCR operation")
@JsonPropertyOrder(value={"Successful", "Lines"})
@JsonTypeName(value="ImageToLinesWithLocationResult")
public class ImageToLinesWithLocationResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_LINES = "Lines";
    private List<OcrLineElement> lines = null;

    public ImageToLinesWithLocationResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public ImageToLinesWithLocationResult lines(List<OcrLineElement> lines) {
        this.lines = lines;
        return this;
    }

    public ImageToLinesWithLocationResult addLinesItem(OcrLineElement linesItem) {
        if (this.lines == null) {
            this.lines = new ArrayList<OcrLineElement>();
        }
        this.lines.add(linesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Words in the image")
    @JsonProperty(value="Lines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OcrLineElement> getLines() {
        return this.lines;
    }

    public void setLines(List<OcrLineElement> lines) {
        this.lines = lines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageToLinesWithLocationResult imageToLinesWithLocationResult = (ImageToLinesWithLocationResult)o;
        return Objects.equals(this.successful, imageToLinesWithLocationResult.successful) && Objects.equals(this.lines, imageToLinesWithLocationResult.lines);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.lines);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageToLinesWithLocationResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    lines: ").append(this.toIndentedString(this.lines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

