/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.ImageMetadataExifValue;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata from an image")
@JsonPropertyOrder(value={"Successful", "IsValidImage", "FileFormat", "Width", "Height", "BitDepth", "HasTransparency", "ColorSpace", "ExifProfileName", "ExifValues"})
@JsonTypeName(value="ImageMetadata")
public class ImageMetadata {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_IS_VALID_IMAGE = "IsValidImage";
    private Boolean isValidImage;
    public static final String JSON_PROPERTY_FILE_FORMAT = "FileFormat";
    private String fileFormat;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Integer height;
    public static final String JSON_PROPERTY_BIT_DEPTH = "BitDepth";
    private Integer bitDepth;
    public static final String JSON_PROPERTY_HAS_TRANSPARENCY = "HasTransparency";
    private Boolean hasTransparency;
    public static final String JSON_PROPERTY_COLOR_SPACE = "ColorSpace";
    private String colorSpace;
    public static final String JSON_PROPERTY_EXIF_PROFILE_NAME = "ExifProfileName";
    private String exifProfileName;
    public static final String JSON_PROPERTY_EXIF_VALUES = "ExifValues";
    private List<ImageMetadataExifValue> exifValues = null;

    public ImageMetadata successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public ImageMetadata isValidImage(Boolean isValidImage) {
        this.isValidImage = isValidImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the input image is a valid image file, false otherwise")
    @JsonProperty(value="IsValidImage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsValidImage() {
        return this.isValidImage;
    }

    public void setIsValidImage(Boolean isValidImage) {
        this.isValidImage = isValidImage;
    }

    public ImageMetadata fileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="File format of the image")
    @JsonProperty(value="FileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public ImageMetadata width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width of the image in pixels")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public ImageMetadata height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height of the image in pixels")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public ImageMetadata bitDepth(Integer bitDepth) {
        this.bitDepth = bitDepth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Bits per pixel")
    @JsonProperty(value="BitDepth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBitDepth() {
        return this.bitDepth;
    }

    public void setBitDepth(Integer bitDepth) {
        this.bitDepth = bitDepth;
    }

    public ImageMetadata hasTransparency(Boolean hasTransparency) {
        this.hasTransparency = hasTransparency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the image has transaprency in the form of an alpha channel, false otherwise")
    @JsonProperty(value="HasTransparency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasTransparency() {
        return this.hasTransparency;
    }

    public void setHasTransparency(Boolean hasTransparency) {
        this.hasTransparency = hasTransparency;
    }

    public ImageMetadata colorSpace(String colorSpace) {
        this.colorSpace = colorSpace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Color space of the image")
    @JsonProperty(value="ColorSpace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(String colorSpace) {
        this.colorSpace = colorSpace;
    }

    public ImageMetadata exifProfileName(String exifProfileName) {
        this.exifProfileName = exifProfileName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the EXIF profile used")
    @JsonProperty(value="ExifProfileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExifProfileName() {
        return this.exifProfileName;
    }

    public void setExifProfileName(String exifProfileName) {
        this.exifProfileName = exifProfileName;
    }

    public ImageMetadata exifValues(List<ImageMetadataExifValue> exifValues) {
        this.exifValues = exifValues;
        return this;
    }

    public ImageMetadata addExifValuesItem(ImageMetadataExifValue exifValuesItem) {
        if (this.exifValues == null) {
            this.exifValues = new ArrayList<ImageMetadataExifValue>();
        }
        this.exifValues.add(exifValuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EXIF tags and values embedded in the image")
    @JsonProperty(value="ExifValues")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ImageMetadataExifValue> getExifValues() {
        return this.exifValues;
    }

    public void setExifValues(List<ImageMetadataExifValue> exifValues) {
        this.exifValues = exifValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageMetadata imageMetadata = (ImageMetadata)o;
        return Objects.equals(this.successful, imageMetadata.successful) && Objects.equals(this.isValidImage, imageMetadata.isValidImage) && Objects.equals(this.fileFormat, imageMetadata.fileFormat) && Objects.equals(this.width, imageMetadata.width) && Objects.equals(this.height, imageMetadata.height) && Objects.equals(this.bitDepth, imageMetadata.bitDepth) && Objects.equals(this.hasTransparency, imageMetadata.hasTransparency) && Objects.equals(this.colorSpace, imageMetadata.colorSpace) && Objects.equals(this.exifProfileName, imageMetadata.exifProfileName) && Objects.equals(this.exifValues, imageMetadata.exifValues);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.isValidImage, this.fileFormat, this.width, this.height, this.bitDepth, this.hasTransparency, this.colorSpace, this.exifProfileName, this.exifValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageMetadata {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    isValidImage: ").append(this.toIndentedString(this.isValidImage)).append("\n");
        sb.append("    fileFormat: ").append(this.toIndentedString(this.fileFormat)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    bitDepth: ").append(this.toIndentedString(this.bitDepth)).append("\n");
        sb.append("    hasTransparency: ").append(this.toIndentedString(this.hasTransparency)).append("\n");
        sb.append("    colorSpace: ").append(this.toIndentedString(this.colorSpace)).append("\n");
        sb.append("    exifProfileName: ").append(this.toIndentedString(this.exifProfileName)).append("\n");
        sb.append("    exifValues: ").append(this.toIndentedString(this.exifValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

