/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.RecognitionOutcome;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of recognizing an image")
@JsonPropertyOrder(value={"Successful", "Highconfidence", "BestOutcome", "RunnerUpOutcome"})
@JsonTypeName(value="ImageDescriptionResponse")
public class ImageDescriptionResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_HIGHCONFIDENCE = "Highconfidence";
    private Boolean highconfidence;
    public static final String JSON_PROPERTY_BEST_OUTCOME = "BestOutcome";
    private RecognitionOutcome bestOutcome;
    public static final String JSON_PROPERTY_RUNNER_UP_OUTCOME = "RunnerUpOutcome";
    private RecognitionOutcome runnerUpOutcome;

    public ImageDescriptionResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Was the image processed successfully?")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public ImageDescriptionResponse highconfidence(Boolean highconfidence) {
        this.highconfidence = highconfidence;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is the resulting best outcome recognition a high confidence outcome?")
    @JsonProperty(value="Highconfidence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHighconfidence() {
        return this.highconfidence;
    }

    public void setHighconfidence(Boolean highconfidence) {
        this.highconfidence = highconfidence;
    }

    public ImageDescriptionResponse bestOutcome(RecognitionOutcome bestOutcome) {
        this.bestOutcome = bestOutcome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="BestOutcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RecognitionOutcome getBestOutcome() {
        return this.bestOutcome;
    }

    public void setBestOutcome(RecognitionOutcome bestOutcome) {
        this.bestOutcome = bestOutcome;
    }

    public ImageDescriptionResponse runnerUpOutcome(RecognitionOutcome runnerUpOutcome) {
        this.runnerUpOutcome = runnerUpOutcome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="RunnerUpOutcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RecognitionOutcome getRunnerUpOutcome() {
        return this.runnerUpOutcome;
    }

    public void setRunnerUpOutcome(RecognitionOutcome runnerUpOutcome) {
        this.runnerUpOutcome = runnerUpOutcome;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageDescriptionResponse imageDescriptionResponse = (ImageDescriptionResponse)o;
        return Objects.equals(this.successful, imageDescriptionResponse.successful) && Objects.equals(this.highconfidence, imageDescriptionResponse.highconfidence) && Objects.equals(this.bestOutcome, imageDescriptionResponse.bestOutcome) && Objects.equals(this.runnerUpOutcome, imageDescriptionResponse.runnerUpOutcome);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.highconfidence, this.bestOutcome, this.runnerUpOutcome);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageDescriptionResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    highconfidence: ").append(this.toIndentedString(this.highconfidence)).append("\n");
        sb.append("    bestOutcome: ").append(this.toIndentedString(this.bestOutcome)).append("\n");
        sb.append("    runnerUpOutcome: ").append(this.toIndentedString(this.runnerUpOutcome)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

