/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.HttpFormDataParameter;
import com.cloudmersive.client.rt.model.HttpGetParameter;
import com.cloudmersive.client.rt.model.HttpOrchestrationHeader;
import com.cloudmersive.client.rt.model.HttpRawBinaryParameter;
import com.cloudmersive.client.rt.model.HttpRawTextParameter;
import com.cloudmersive.client.rt.model.HttpWwwFormUrlEncodedParameter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"TaskName", "HttpMethod", "URL", "HttpHeaders", "QueryParameters", "FormDataParameters", "WwwFormUrlEncodedParameters", "RawTextBody", "RawBinaryBody"})
@JsonTypeName(value="HttpOrchestrationTask")
public class HttpOrchestrationTask {
    public static final String JSON_PROPERTY_TASK_NAME = "TaskName";
    private String taskName;
    public static final String JSON_PROPERTY_HTTP_METHOD = "HttpMethod";
    private String httpMethod;
    public static final String JSON_PROPERTY_U_R_L = "URL";
    private String URL;
    public static final String JSON_PROPERTY_HTTP_HEADERS = "HttpHeaders";
    private List<HttpOrchestrationHeader> httpHeaders = null;
    public static final String JSON_PROPERTY_QUERY_PARAMETERS = "QueryParameters";
    private List<HttpGetParameter> queryParameters = null;
    public static final String JSON_PROPERTY_FORM_DATA_PARAMETERS = "FormDataParameters";
    private List<HttpFormDataParameter> formDataParameters = null;
    public static final String JSON_PROPERTY_WWW_FORM_URL_ENCODED_PARAMETERS = "WwwFormUrlEncodedParameters";
    private List<HttpWwwFormUrlEncodedParameter> wwwFormUrlEncodedParameters = null;
    public static final String JSON_PROPERTY_RAW_TEXT_BODY = "RawTextBody";
    private HttpRawTextParameter rawTextBody;
    public static final String JSON_PROPERTY_RAW_BINARY_BODY = "RawBinaryBody";
    private HttpRawBinaryParameter rawBinaryBody;

    public HttpOrchestrationTask taskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An identifier for this task name, e.g. CreateCustomer or ScanForVirus; allows you to refer to this task from other tasks; if not supplied, it will default to a 0-based integer index of the task")
    @JsonProperty(value="TaskName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public HttpOrchestrationTask httpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HTTP Method, e.g. GET, PUT, POST, etc.")
    @JsonProperty(value="HttpMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public HttpOrchestrationTask URL(String URL2) {
        this.URL = URL2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HTTP URL to orchestrate")
    @JsonProperty(value="URL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public HttpOrchestrationTask httpHeaders(List<HttpOrchestrationHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public HttpOrchestrationTask addHttpHeadersItem(HttpOrchestrationHeader httpHeadersItem) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<HttpOrchestrationHeader>();
        }
        this.httpHeaders.add(httpHeadersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; HTTP headers to apply to the request")
    @JsonProperty(value="HttpHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HttpOrchestrationHeader> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(List<HttpOrchestrationHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public HttpOrchestrationTask queryParameters(List<HttpGetParameter> queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public HttpOrchestrationTask addQueryParametersItem(HttpGetParameter queryParametersItem) {
        if (this.queryParameters == null) {
            this.queryParameters = new ArrayList<HttpGetParameter>();
        }
        this.queryParameters.add(queryParametersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; query parameters, these query parameters will be incorporated into the URL")
    @JsonProperty(value="QueryParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HttpGetParameter> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(List<HttpGetParameter> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public HttpOrchestrationTask formDataParameters(List<HttpFormDataParameter> formDataParameters) {
        this.formDataParameters = formDataParameters;
        return this;
    }

    public HttpOrchestrationTask addFormDataParametersItem(HttpFormDataParameter formDataParametersItem) {
        if (this.formDataParameters == null) {
            this.formDataParameters = new ArrayList<HttpFormDataParameter>();
        }
        this.formDataParameters.add(formDataParametersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; FormData parameters, these parameters will be stored in the body in a multi-part encoding")
    @JsonProperty(value="FormDataParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HttpFormDataParameter> getFormDataParameters() {
        return this.formDataParameters;
    }

    public void setFormDataParameters(List<HttpFormDataParameter> formDataParameters) {
        this.formDataParameters = formDataParameters;
    }

    public HttpOrchestrationTask wwwFormUrlEncodedParameters(List<HttpWwwFormUrlEncodedParameter> wwwFormUrlEncodedParameters) {
        this.wwwFormUrlEncodedParameters = wwwFormUrlEncodedParameters;
        return this;
    }

    public HttpOrchestrationTask addWwwFormUrlEncodedParametersItem(HttpWwwFormUrlEncodedParameter wwwFormUrlEncodedParametersItem) {
        if (this.wwwFormUrlEncodedParameters == null) {
            this.wwwFormUrlEncodedParameters = new ArrayList<HttpWwwFormUrlEncodedParameter>();
        }
        this.wwwFormUrlEncodedParameters.add(wwwFormUrlEncodedParametersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; x-www-form-urlencoded paramereters, these parameters will be stored in the body as an application/x-www-form-urlencoded encoding")
    @JsonProperty(value="WwwFormUrlEncodedParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HttpWwwFormUrlEncodedParameter> getWwwFormUrlEncodedParameters() {
        return this.wwwFormUrlEncodedParameters;
    }

    public void setWwwFormUrlEncodedParameters(List<HttpWwwFormUrlEncodedParameter> wwwFormUrlEncodedParameters) {
        this.wwwFormUrlEncodedParameters = wwwFormUrlEncodedParameters;
    }

    public HttpOrchestrationTask rawTextBody(HttpRawTextParameter rawTextBody) {
        this.rawTextBody = rawTextBody;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="RawTextBody")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HttpRawTextParameter getRawTextBody() {
        return this.rawTextBody;
    }

    public void setRawTextBody(HttpRawTextParameter rawTextBody) {
        this.rawTextBody = rawTextBody;
    }

    public HttpOrchestrationTask rawBinaryBody(HttpRawBinaryParameter rawBinaryBody) {
        this.rawBinaryBody = rawBinaryBody;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="RawBinaryBody")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HttpRawBinaryParameter getRawBinaryBody() {
        return this.rawBinaryBody;
    }

    public void setRawBinaryBody(HttpRawBinaryParameter rawBinaryBody) {
        this.rawBinaryBody = rawBinaryBody;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpOrchestrationTask httpOrchestrationTask = (HttpOrchestrationTask)o;
        return Objects.equals(this.taskName, httpOrchestrationTask.taskName) && Objects.equals(this.httpMethod, httpOrchestrationTask.httpMethod) && Objects.equals(this.URL, httpOrchestrationTask.URL) && Objects.equals(this.httpHeaders, httpOrchestrationTask.httpHeaders) && Objects.equals(this.queryParameters, httpOrchestrationTask.queryParameters) && Objects.equals(this.formDataParameters, httpOrchestrationTask.formDataParameters) && Objects.equals(this.wwwFormUrlEncodedParameters, httpOrchestrationTask.wwwFormUrlEncodedParameters) && Objects.equals(this.rawTextBody, httpOrchestrationTask.rawTextBody) && Objects.equals(this.rawBinaryBody, httpOrchestrationTask.rawBinaryBody);
    }

    public int hashCode() {
        return Objects.hash(this.taskName, this.httpMethod, this.URL, this.httpHeaders, this.queryParameters, this.formDataParameters, this.wwwFormUrlEncodedParameters, this.rawTextBody, this.rawBinaryBody);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HttpOrchestrationTask {\n");
        sb.append("    taskName: ").append(this.toIndentedString(this.taskName)).append("\n");
        sb.append("    httpMethod: ").append(this.toIndentedString(this.httpMethod)).append("\n");
        sb.append("    URL: ").append(this.toIndentedString(this.URL)).append("\n");
        sb.append("    httpHeaders: ").append(this.toIndentedString(this.httpHeaders)).append("\n");
        sb.append("    queryParameters: ").append(this.toIndentedString(this.queryParameters)).append("\n");
        sb.append("    formDataParameters: ").append(this.toIndentedString(this.formDataParameters)).append("\n");
        sb.append("    wwwFormUrlEncodedParameters: ").append(this.toIndentedString(this.wwwFormUrlEncodedParameters)).append("\n");
        sb.append("    rawTextBody: ").append(this.toIndentedString(this.rawTextBody)).append("\n");
        sb.append("    rawBinaryBody: ").append(this.toIndentedString(this.rawBinaryBody)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

