/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of performing an HTTP orchestration")
@JsonPropertyOrder(value={"Successful", "TasksCompleted", "Output_StringType", "Output_BinaryType"})
@JsonTypeName(value="HttpOrchestrationResponse")
public class HttpOrchestrationResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_TASKS_COMPLETED = "TasksCompleted";
    private Integer tasksCompleted;
    public static final String JSON_PROPERTY_OUTPUT_STRING_TYPE = "Output_StringType";
    private String outputStringType;
    public static final String JSON_PROPERTY_OUTPUT_BINARY_TYPE = "Output_BinaryType";
    private byte[] outputBinaryType;

    public HttpOrchestrationResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public HttpOrchestrationResponse tasksCompleted(Integer tasksCompleted) {
        this.tasksCompleted = tasksCompleted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count of the number of tasks that were completed")
    @JsonProperty(value="TasksCompleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTasksCompleted() {
        return this.tasksCompleted;
    }

    public void setTasksCompleted(Integer tasksCompleted) {
        this.tasksCompleted = tasksCompleted;
    }

    public HttpOrchestrationResponse outputStringType(String outputStringType) {
        this.outputStringType = outputStringType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Result output in string format")
    @JsonProperty(value="Output_StringType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOutputStringType() {
        return this.outputStringType;
    }

    public void setOutputStringType(String outputStringType) {
        this.outputStringType = outputStringType;
    }

    public HttpOrchestrationResponse outputBinaryType(byte[] outputBinaryType) {
        this.outputBinaryType = outputBinaryType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Result output in binary format")
    @JsonProperty(value="Output_BinaryType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getOutputBinaryType() {
        return this.outputBinaryType;
    }

    public void setOutputBinaryType(byte[] outputBinaryType) {
        this.outputBinaryType = outputBinaryType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpOrchestrationResponse httpOrchestrationResponse = (HttpOrchestrationResponse)o;
        return Objects.equals(this.successful, httpOrchestrationResponse.successful) && Objects.equals(this.tasksCompleted, httpOrchestrationResponse.tasksCompleted) && Objects.equals(this.outputStringType, httpOrchestrationResponse.outputStringType) && Arrays.equals(this.outputBinaryType, httpOrchestrationResponse.outputBinaryType);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.tasksCompleted, this.outputStringType, Arrays.hashCode(this.outputBinaryType));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HttpOrchestrationResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    tasksCompleted: ").append(this.toIndentedString(this.tasksCompleted)).append("\n");
        sb.append("    outputStringType: ").append(this.toIndentedString(this.outputStringType)).append("\n");
        sb.append("    outputBinaryType: ").append(this.toIndentedString(this.outputBinaryType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

