/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.TaskOutputReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines a parameter of type FormData (multipart/form-data)")
@JsonPropertyOrder(value={"ParameterName", "ParameterTextValue", "ParameterFileContents", "UseOutputFromPreviousTask"})
@JsonTypeName(value="HttpFormDataParameter")
public class HttpFormDataParameter {
    public static final String JSON_PROPERTY_PARAMETER_NAME = "ParameterName";
    private String parameterName;
    public static final String JSON_PROPERTY_PARAMETER_TEXT_VALUE = "ParameterTextValue";
    private String parameterTextValue;
    public static final String JSON_PROPERTY_PARAMETER_FILE_CONTENTS = "ParameterFileContents";
    private byte[] parameterFileContents;
    public static final String JSON_PROPERTY_USE_OUTPUT_FROM_PREVIOUS_TASK = "UseOutputFromPreviousTask";
    private TaskOutputReference useOutputFromPreviousTask;

    public HttpFormDataParameter parameterName(String parameterName) {
        this.parameterName = parameterName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the parameter")
    @JsonProperty(value="ParameterName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public HttpFormDataParameter parameterTextValue(String parameterTextValue) {
        this.parameterTextValue = parameterTextValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text value of the parameter; if set, do not set ParameterFileContents or UseOutputFromPreviousTask")
    @JsonProperty(value="ParameterTextValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParameterTextValue() {
        return this.parameterTextValue;
    }

    public void setParameterTextValue(String parameterTextValue) {
        this.parameterTextValue = parameterTextValue;
    }

    public HttpFormDataParameter parameterFileContents(byte[] parameterFileContents) {
        this.parameterFileContents = parameterFileContents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Binary contents of the parameter; if set, do not set ParameterTextValue or UseOutputFromPreviousTask")
    @JsonProperty(value="ParameterFileContents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getParameterFileContents() {
        return this.parameterFileContents;
    }

    public void setParameterFileContents(byte[] parameterFileContents) {
        this.parameterFileContents = parameterFileContents;
    }

    public HttpFormDataParameter useOutputFromPreviousTask(TaskOutputReference useOutputFromPreviousTask) {
        this.useOutputFromPreviousTask = useOutputFromPreviousTask;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="UseOutputFromPreviousTask")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TaskOutputReference getUseOutputFromPreviousTask() {
        return this.useOutputFromPreviousTask;
    }

    public void setUseOutputFromPreviousTask(TaskOutputReference useOutputFromPreviousTask) {
        this.useOutputFromPreviousTask = useOutputFromPreviousTask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpFormDataParameter httpFormDataParameter = (HttpFormDataParameter)o;
        return Objects.equals(this.parameterName, httpFormDataParameter.parameterName) && Objects.equals(this.parameterTextValue, httpFormDataParameter.parameterTextValue) && Arrays.equals(this.parameterFileContents, httpFormDataParameter.parameterFileContents) && Objects.equals(this.useOutputFromPreviousTask, httpFormDataParameter.useOutputFromPreviousTask);
    }

    public int hashCode() {
        return Objects.hash(this.parameterName, this.parameterTextValue, Arrays.hashCode(this.parameterFileContents), this.useOutputFromPreviousTask);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HttpFormDataParameter {\n");
        sb.append("    parameterName: ").append(this.toIndentedString(this.parameterName)).append("\n");
        sb.append("    parameterTextValue: ").append(this.toIndentedString(this.parameterTextValue)).append("\n");
        sb.append("    parameterFileContents: ").append(this.toIndentedString(this.parameterFileContents)).append("\n");
        sb.append("    useOutputFromPreviousTask: ").append(this.toIndentedString(this.useOutputFromPreviousTask)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

