/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.PersonWithGender;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result from classifying the Gender of people in an image")
@JsonPropertyOrder(value={"Successful", "PersonWithGender", "PeopleIdentified"})
@JsonTypeName(value="GenderDetectionResult")
public class GenderDetectionResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_PERSON_WITH_GENDER = "PersonWithGender";
    private List<PersonWithGender> personWithGender = null;
    public static final String JSON_PROPERTY_PEOPLE_IDENTIFIED = "PeopleIdentified";
    private Integer peopleIdentified;

    public GenderDetectionResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public GenderDetectionResult personWithGender(List<PersonWithGender> personWithGender) {
        this.personWithGender = personWithGender;
        return this;
    }

    public GenderDetectionResult addPersonWithGenderItem(PersonWithGender personWithGenderItem) {
        if (this.personWithGender == null) {
            this.personWithGender = new ArrayList<PersonWithGender>();
        }
        this.personWithGender.add(personWithGenderItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="People in the image annotated with gender information")
    @JsonProperty(value="PersonWithGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PersonWithGender> getPersonWithGender() {
        return this.personWithGender;
    }

    public void setPersonWithGender(List<PersonWithGender> personWithGender) {
        this.personWithGender = personWithGender;
    }

    public GenderDetectionResult peopleIdentified(Integer peopleIdentified) {
        this.peopleIdentified = peopleIdentified;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of people identified in the image with a gender")
    @JsonProperty(value="PeopleIdentified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPeopleIdentified() {
        return this.peopleIdentified;
    }

    public void setPeopleIdentified(Integer peopleIdentified) {
        this.peopleIdentified = peopleIdentified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenderDetectionResult genderDetectionResult = (GenderDetectionResult)o;
        return Objects.equals(this.successful, genderDetectionResult.successful) && Objects.equals(this.personWithGender, genderDetectionResult.personWithGender) && Objects.equals(this.peopleIdentified, genderDetectionResult.peopleIdentified);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.personWithGender, this.peopleIdentified);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenderDetectionResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    personWithGender: ").append(this.toIndentedString(this.personWithGender)).append("\n");
        sb.append("    peopleIdentified: ").append(this.toIndentedString(this.peopleIdentified)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

