/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Full email addresss validation result")
@JsonPropertyOrder(value={"ValidAddress", "MailServerUsedForValidation", "Valid_Syntax", "Valid_Domain", "Valid_SMTP", "IsCatchallDomain", "Domain", "IsFreeEmailProvider", "IsDisposable"})
@JsonTypeName(value="FullEmailValidationResponse")
public class FullEmailValidationResponse {
    public static final String JSON_PROPERTY_VALID_ADDRESS = "ValidAddress";
    private Boolean validAddress;
    public static final String JSON_PROPERTY_MAIL_SERVER_USED_FOR_VALIDATION = "MailServerUsedForValidation";
    private String mailServerUsedForValidation;
    public static final String JSON_PROPERTY_VALID_SYNTAX = "Valid_Syntax";
    private Boolean validSyntax;
    public static final String JSON_PROPERTY_VALID_DOMAIN = "Valid_Domain";
    private Boolean validDomain;
    public static final String JSON_PROPERTY_VALID_S_M_T_P = "Valid_SMTP";
    private Boolean validSMTP;
    public static final String JSON_PROPERTY_IS_CATCHALL_DOMAIN = "IsCatchallDomain";
    private Boolean isCatchallDomain;
    public static final String JSON_PROPERTY_DOMAIN = "Domain";
    private String domain;
    public static final String JSON_PROPERTY_IS_FREE_EMAIL_PROVIDER = "IsFreeEmailProvider";
    private Boolean isFreeEmailProvider;
    public static final String JSON_PROPERTY_IS_DISPOSABLE = "IsDisposable";
    private Boolean isDisposable;

    public FullEmailValidationResponse validAddress(Boolean validAddress) {
        this.validAddress = validAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the email address is valid overall, false otherwise")
    @JsonProperty(value="ValidAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValidAddress() {
        return this.validAddress;
    }

    public void setValidAddress(Boolean validAddress) {
        this.validAddress = validAddress;
    }

    public FullEmailValidationResponse mailServerUsedForValidation(String mailServerUsedForValidation) {
        this.mailServerUsedForValidation = mailServerUsedForValidation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Email server connected to for verification")
    @JsonProperty(value="MailServerUsedForValidation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMailServerUsedForValidation() {
        return this.mailServerUsedForValidation;
    }

    public void setMailServerUsedForValidation(String mailServerUsedForValidation) {
        this.mailServerUsedForValidation = mailServerUsedForValidation;
    }

    public FullEmailValidationResponse validSyntax(Boolean validSyntax) {
        this.validSyntax = validSyntax;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the syntax of the email address is valid, false otherwise.  This is one component of ValidAddress, but not the only one.")
    @JsonProperty(value="Valid_Syntax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValidSyntax() {
        return this.validSyntax;
    }

    public void setValidSyntax(Boolean validSyntax) {
        this.validSyntax = validSyntax;
    }

    public FullEmailValidationResponse validDomain(Boolean validDomain) {
        this.validDomain = validDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the domain name of the email address is valid, false otherwise.  This is one component of ValidAddress, but not the only one.")
    @JsonProperty(value="Valid_Domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValidDomain() {
        return this.validDomain;
    }

    public void setValidDomain(Boolean validDomain) {
        this.validDomain = validDomain;
    }

    public FullEmailValidationResponse validSMTP(Boolean validSMTP) {
        this.validSMTP = validSMTP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the email address was verified by the remote server, false otherwise.  This is one component of ValidAddress, but not the only one.")
    @JsonProperty(value="Valid_SMTP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValidSMTP() {
        return this.validSMTP;
    }

    public void setValidSMTP(Boolean validSMTP) {
        this.validSMTP = validSMTP;
    }

    public FullEmailValidationResponse isCatchallDomain(Boolean isCatchallDomain) {
        this.isCatchallDomain = isCatchallDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the domain is a catch-all domain name, false otherwise.  Catch-all domain names, while rare, always accept inbound email to ensure they do not lose any potentially useful emails.  Catch-all domain names can occassionally be configured to first accept and store all inbound email, but then later send a bounce email back to the sender after a delayed period of time.")
    @JsonProperty(value="IsCatchallDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCatchallDomain() {
        return this.isCatchallDomain;
    }

    public void setIsCatchallDomain(Boolean isCatchallDomain) {
        this.isCatchallDomain = isCatchallDomain;
    }

    public FullEmailValidationResponse domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Domain name of the email address")
    @JsonProperty(value="Domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public FullEmailValidationResponse isFreeEmailProvider(Boolean isFreeEmailProvider) {
        this.isFreeEmailProvider = isFreeEmailProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the email domain name is a free provider (typically a free to sign up web email provider for consumers / personal use), false otherwise.")
    @JsonProperty(value="IsFreeEmailProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsFreeEmailProvider() {
        return this.isFreeEmailProvider;
    }

    public void setIsFreeEmailProvider(Boolean isFreeEmailProvider) {
        this.isFreeEmailProvider = isFreeEmailProvider;
    }

    public FullEmailValidationResponse isDisposable(Boolean isDisposable) {
        this.isDisposable = isDisposable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the email address is a disposable email address, false otherwise; these disposable providers are not typically used to receive email and so will have a low likelihood of opening mail sent there.")
    @JsonProperty(value="IsDisposable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsDisposable() {
        return this.isDisposable;
    }

    public void setIsDisposable(Boolean isDisposable) {
        this.isDisposable = isDisposable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullEmailValidationResponse fullEmailValidationResponse = (FullEmailValidationResponse)o;
        return Objects.equals(this.validAddress, fullEmailValidationResponse.validAddress) && Objects.equals(this.mailServerUsedForValidation, fullEmailValidationResponse.mailServerUsedForValidation) && Objects.equals(this.validSyntax, fullEmailValidationResponse.validSyntax) && Objects.equals(this.validDomain, fullEmailValidationResponse.validDomain) && Objects.equals(this.validSMTP, fullEmailValidationResponse.validSMTP) && Objects.equals(this.isCatchallDomain, fullEmailValidationResponse.isCatchallDomain) && Objects.equals(this.domain, fullEmailValidationResponse.domain) && Objects.equals(this.isFreeEmailProvider, fullEmailValidationResponse.isFreeEmailProvider) && Objects.equals(this.isDisposable, fullEmailValidationResponse.isDisposable);
    }

    public int hashCode() {
        return Objects.hash(this.validAddress, this.mailServerUsedForValidation, this.validSyntax, this.validDomain, this.validSMTP, this.isCatchallDomain, this.domain, this.isFreeEmailProvider, this.isDisposable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FullEmailValidationResponse {\n");
        sb.append("    validAddress: ").append(this.toIndentedString(this.validAddress)).append("\n");
        sb.append("    mailServerUsedForValidation: ").append(this.toIndentedString(this.mailServerUsedForValidation)).append("\n");
        sb.append("    validSyntax: ").append(this.toIndentedString(this.validSyntax)).append("\n");
        sb.append("    validDomain: ").append(this.toIndentedString(this.validDomain)).append("\n");
        sb.append("    validSMTP: ").append(this.toIndentedString(this.validSMTP)).append("\n");
        sb.append("    isCatchallDomain: ").append(this.toIndentedString(this.isCatchallDomain)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    isFreeEmailProvider: ").append(this.toIndentedString(this.isFreeEmailProvider)).append("\n");
        sb.append("    isDisposable: ").append(this.toIndentedString(this.isDisposable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

