/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.FormTableColumnDefinition;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Definition of a form table for OCR data extraction from images")
@JsonPropertyOrder(value={"TableID", "ColumnDefinitions", "TargetTableHeight_Relative", "TargetRowHeight_Relative"})
@JsonTypeName(value="FormTableDefinition")
public class FormTableDefinition {
    public static final String JSON_PROPERTY_TABLE_I_D = "TableID";
    private String tableID;
    public static final String JSON_PROPERTY_COLUMN_DEFINITIONS = "ColumnDefinitions";
    private List<FormTableColumnDefinition> columnDefinitions = null;
    public static final String JSON_PROPERTY_TARGET_TABLE_HEIGHT_RELATIVE = "TargetTableHeight_Relative";
    private Double targetTableHeightRelative;
    public static final String JSON_PROPERTY_TARGET_ROW_HEIGHT_RELATIVE = "TargetRowHeight_Relative";
    private Double targetRowHeightRelative;

    public FormTableDefinition tableID(String tableID) {
        this.tableID = tableID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; the ID of the table")
    @JsonProperty(value="TableID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTableID() {
        return this.tableID;
    }

    public void setTableID(String tableID) {
        this.tableID = tableID;
    }

    public FormTableDefinition columnDefinitions(List<FormTableColumnDefinition> columnDefinitions) {
        this.columnDefinitions = columnDefinitions;
        return this;
    }

    public FormTableDefinition addColumnDefinitionsItem(FormTableColumnDefinition columnDefinitionsItem) {
        if (this.columnDefinitions == null) {
            this.columnDefinitions = new ArrayList<FormTableColumnDefinition>();
        }
        this.columnDefinitions.add(columnDefinitionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Definition of the columns in the table")
    @JsonProperty(value="ColumnDefinitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FormTableColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(List<FormTableColumnDefinition> columnDefinitions) {
        this.columnDefinitions = columnDefinitions;
    }

    public FormTableDefinition targetTableHeightRelative(Double targetTableHeightRelative) {
        this.targetTableHeightRelative = targetTableHeightRelative;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - scale factor for target table height - relative to maximum height of headers of columns")
    @JsonProperty(value="TargetTableHeight_Relative")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTargetTableHeightRelative() {
        return this.targetTableHeightRelative;
    }

    public void setTargetTableHeightRelative(Double targetTableHeightRelative) {
        this.targetTableHeightRelative = targetTableHeightRelative;
    }

    public FormTableDefinition targetRowHeightRelative(Double targetRowHeightRelative) {
        this.targetRowHeightRelative = targetRowHeightRelative;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - scale factor for target row height - relative to height of column header")
    @JsonProperty(value="TargetRowHeight_Relative")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTargetRowHeightRelative() {
        return this.targetRowHeightRelative;
    }

    public void setTargetRowHeightRelative(Double targetRowHeightRelative) {
        this.targetRowHeightRelative = targetRowHeightRelative;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormTableDefinition formTableDefinition = (FormTableDefinition)o;
        return Objects.equals(this.tableID, formTableDefinition.tableID) && Objects.equals(this.columnDefinitions, formTableDefinition.columnDefinitions) && Objects.equals(this.targetTableHeightRelative, formTableDefinition.targetTableHeightRelative) && Objects.equals(this.targetRowHeightRelative, formTableDefinition.targetRowHeightRelative);
    }

    public int hashCode() {
        return Objects.hash(this.tableID, this.columnDefinitions, this.targetTableHeightRelative, this.targetRowHeightRelative);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormTableDefinition {\n");
        sb.append("    tableID: ").append(this.toIndentedString(this.tableID)).append("\n");
        sb.append("    columnDefinitions: ").append(this.toIndentedString(this.columnDefinitions)).append("\n");
        sb.append("    targetTableHeightRelative: ").append(this.toIndentedString(this.targetTableHeightRelative)).append("\n");
        sb.append("    targetRowHeightRelative: ").append(this.toIndentedString(this.targetRowHeightRelative)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

