/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Definition of a column within a table for OCR data extraction from images")
@JsonPropertyOrder(value={"ColumnID", "TopAnchor", "AnchorMode", "DataType", "MinimumCharacterCount", "AllowNumericDigits"})
@JsonTypeName(value="FormTableColumnDefinition")
public class FormTableColumnDefinition {
    public static final String JSON_PROPERTY_COLUMN_I_D = "ColumnID";
    private String columnID;
    public static final String JSON_PROPERTY_TOP_ANCHOR = "TopAnchor";
    private String topAnchor;
    public static final String JSON_PROPERTY_ANCHOR_MODE = "AnchorMode";
    private String anchorMode;
    public static final String JSON_PROPERTY_DATA_TYPE = "DataType";
    private String dataType;
    public static final String JSON_PROPERTY_MINIMUM_CHARACTER_COUNT = "MinimumCharacterCount";
    private Integer minimumCharacterCount;
    public static final String JSON_PROPERTY_ALLOW_NUMERIC_DIGITS = "AllowNumericDigits";
    private Boolean allowNumericDigits;

    public FormTableColumnDefinition columnID(String columnID) {
        this.columnID = columnID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the field; use this to identify which field is being referenced")
    @JsonProperty(value="ColumnID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getColumnID() {
        return this.columnID;
    }

    public void setColumnID(String columnID) {
        this.columnID = columnID;
    }

    public FormTableColumnDefinition topAnchor(String topAnchor) {
        this.topAnchor = topAnchor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - the top anchor of the column heading")
    @JsonProperty(value="TopAnchor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTopAnchor() {
        return this.topAnchor;
    }

    public void setTopAnchor(String topAnchor) {
        this.topAnchor = topAnchor;
    }

    public FormTableColumnDefinition anchorMode(String anchorMode) {
        this.anchorMode = anchorMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - the matching mode for the anchor.  Possible values are Complete (requires the entire anchor to match) and Partial (allows only part of the anchor to match).  Default is Partial.")
    @JsonProperty(value="AnchorMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAnchorMode() {
        return this.anchorMode;
    }

    public void setAnchorMode(String anchorMode) {
        this.anchorMode = anchorMode;
    }

    public FormTableColumnDefinition dataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The data type of the field; possible values are INTEGER (Integer value), STRING (Arbitrary string value, spaces are permitted), DATE (Date in a structured format), DECIMAL (Decimal number), ALPHANUMERIC (Continuous alphanumeric string with no spaces), STRINGNOWHITESPACE (A string that contains no whitespace characters), SERIALNUMBER (A serial-number style string that contains letters and numbers, and certain symbols; must contain at least one number), ALPHAONLY (Alphabet characters only, no numbers or symbols or whitespace)")
    @JsonProperty(value="DataType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public FormTableColumnDefinition minimumCharacterCount(Integer minimumCharacterCount) {
        this.minimumCharacterCount = minimumCharacterCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - the target number of digits in the field; useful for fixed-length fields")
    @JsonProperty(value="MinimumCharacterCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinimumCharacterCount() {
        return this.minimumCharacterCount;
    }

    public void setMinimumCharacterCount(Integer minimumCharacterCount) {
        this.minimumCharacterCount = minimumCharacterCount;
    }

    public FormTableColumnDefinition allowNumericDigits(Boolean allowNumericDigits) {
        this.allowNumericDigits = allowNumericDigits;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional - set to false to block values that contain numeric digits, set to true to allow numeric digits")
    @JsonProperty(value="AllowNumericDigits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowNumericDigits() {
        return this.allowNumericDigits;
    }

    public void setAllowNumericDigits(Boolean allowNumericDigits) {
        this.allowNumericDigits = allowNumericDigits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormTableColumnDefinition formTableColumnDefinition = (FormTableColumnDefinition)o;
        return Objects.equals(this.columnID, formTableColumnDefinition.columnID) && Objects.equals(this.topAnchor, formTableColumnDefinition.topAnchor) && Objects.equals(this.anchorMode, formTableColumnDefinition.anchorMode) && Objects.equals(this.dataType, formTableColumnDefinition.dataType) && Objects.equals(this.minimumCharacterCount, formTableColumnDefinition.minimumCharacterCount) && Objects.equals(this.allowNumericDigits, formTableColumnDefinition.allowNumericDigits);
    }

    public int hashCode() {
        return Objects.hash(this.columnID, this.topAnchor, this.anchorMode, this.dataType, this.minimumCharacterCount, this.allowNumericDigits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormTableColumnDefinition {\n");
        sb.append("    columnID: ").append(this.toIndentedString(this.columnID)).append("\n");
        sb.append("    topAnchor: ").append(this.toIndentedString(this.topAnchor)).append("\n");
        sb.append("    anchorMode: ").append(this.toIndentedString(this.anchorMode)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString(this.dataType)).append("\n");
        sb.append("    minimumCharacterCount: ").append(this.toIndentedString(this.minimumCharacterCount)).append("\n");
        sb.append("    allowNumericDigits: ").append(this.toIndentedString(this.allowNumericDigits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

