/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.FieldResult;
import com.cloudmersive.client.rt.model.TableResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The result of extracting form field values")
@JsonPropertyOrder(value={"Successful", "FieldValueExtractionResult", "TableValueExtractionResults", "Diagnostics", "BestMatchFormSettingName"})
@JsonTypeName(value="FormRecognitionResult")
public class FormRecognitionResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_FIELD_VALUE_EXTRACTION_RESULT = "FieldValueExtractionResult";
    private List<FieldResult> fieldValueExtractionResult = null;
    public static final String JSON_PROPERTY_TABLE_VALUE_EXTRACTION_RESULTS = "TableValueExtractionResults";
    private List<TableResult> tableValueExtractionResults = null;
    public static final String JSON_PROPERTY_DIAGNOSTICS = "Diagnostics";
    private List<String> diagnostics = null;
    public static final String JSON_PROPERTY_BEST_MATCH_FORM_SETTING_NAME = "BestMatchFormSettingName";
    private String bestMatchFormSettingName;

    public FormRecognitionResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public FormRecognitionResult fieldValueExtractionResult(List<FieldResult> fieldValueExtractionResult) {
        this.fieldValueExtractionResult = fieldValueExtractionResult;
        return this;
    }

    public FormRecognitionResult addFieldValueExtractionResultItem(FieldResult fieldValueExtractionResultItem) {
        if (this.fieldValueExtractionResult == null) {
            this.fieldValueExtractionResult = new ArrayList<FieldResult>();
        }
        this.fieldValueExtractionResult.add(fieldValueExtractionResultItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Result of form field OCR data extraction")
    @JsonProperty(value="FieldValueExtractionResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FieldResult> getFieldValueExtractionResult() {
        return this.fieldValueExtractionResult;
    }

    public void setFieldValueExtractionResult(List<FieldResult> fieldValueExtractionResult) {
        this.fieldValueExtractionResult = fieldValueExtractionResult;
    }

    public FormRecognitionResult tableValueExtractionResults(List<TableResult> tableValueExtractionResults) {
        this.tableValueExtractionResults = tableValueExtractionResults;
        return this;
    }

    public FormRecognitionResult addTableValueExtractionResultsItem(TableResult tableValueExtractionResultsItem) {
        if (this.tableValueExtractionResults == null) {
            this.tableValueExtractionResults = new ArrayList<TableResult>();
        }
        this.tableValueExtractionResults.add(tableValueExtractionResultsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Result of form table OCR data extraction")
    @JsonProperty(value="TableValueExtractionResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TableResult> getTableValueExtractionResults() {
        return this.tableValueExtractionResults;
    }

    public void setTableValueExtractionResults(List<TableResult> tableValueExtractionResults) {
        this.tableValueExtractionResults = tableValueExtractionResults;
    }

    public FormRecognitionResult diagnostics(List<String> diagnostics) {
        this.diagnostics = diagnostics;
        return this;
    }

    public FormRecognitionResult addDiagnosticsItem(String diagnosticsItem) {
        if (this.diagnostics == null) {
            this.diagnostics = new ArrayList<String>();
        }
        this.diagnostics.add(diagnosticsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Diagnostic images - default is null, enable diagnostics=true to populate this parameter with one image per field")
    @JsonProperty(value="Diagnostics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(List<String> diagnostics) {
        this.diagnostics = diagnostics;
    }

    public FormRecognitionResult bestMatchFormSettingName(String bestMatchFormSettingName) {
        this.bestMatchFormSettingName = bestMatchFormSettingName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; populated when using photo/recognize/form/advanced with the Setting Name of the best-matching highest-relevance form")
    @JsonProperty(value="BestMatchFormSettingName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBestMatchFormSettingName() {
        return this.bestMatchFormSettingName;
    }

    public void setBestMatchFormSettingName(String bestMatchFormSettingName) {
        this.bestMatchFormSettingName = bestMatchFormSettingName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormRecognitionResult formRecognitionResult = (FormRecognitionResult)o;
        return Objects.equals(this.successful, formRecognitionResult.successful) && Objects.equals(this.fieldValueExtractionResult, formRecognitionResult.fieldValueExtractionResult) && Objects.equals(this.tableValueExtractionResults, formRecognitionResult.tableValueExtractionResults) && Objects.equals(this.diagnostics, formRecognitionResult.diagnostics) && Objects.equals(this.bestMatchFormSettingName, formRecognitionResult.bestMatchFormSettingName);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.fieldValueExtractionResult, this.tableValueExtractionResults, this.diagnostics, this.bestMatchFormSettingName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormRecognitionResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    fieldValueExtractionResult: ").append(this.toIndentedString(this.fieldValueExtractionResult)).append("\n");
        sb.append("    tableValueExtractionResults: ").append(this.toIndentedString(this.tableValueExtractionResults)).append("\n");
        sb.append("    diagnostics: ").append(this.toIndentedString(this.diagnostics)).append("\n");
        sb.append("    bestMatchFormSettingName: ").append(this.toIndentedString(this.bestMatchFormSettingName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

