/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.FormFieldDefinition;
import com.cloudmersive.client.rt.model.FormTableDefinition;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Definition of a form template; use a form template definition to recognize the fields in a form with Cloudmersive OCR")
@JsonPropertyOrder(value={"FieldDefinitions", "TableDefinitions"})
@JsonTypeName(value="FormDefinitionTemplate")
public class FormDefinitionTemplate {
    public static final String JSON_PROPERTY_FIELD_DEFINITIONS = "FieldDefinitions";
    private List<FormFieldDefinition> fieldDefinitions = null;
    public static final String JSON_PROPERTY_TABLE_DEFINITIONS = "TableDefinitions";
    private List<FormTableDefinition> tableDefinitions = null;

    public FormDefinitionTemplate fieldDefinitions(List<FormFieldDefinition> fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
        return this;
    }

    public FormDefinitionTemplate addFieldDefinitionsItem(FormFieldDefinition fieldDefinitionsItem) {
        if (this.fieldDefinitions == null) {
            this.fieldDefinitions = new ArrayList<FormFieldDefinition>();
        }
        this.fieldDefinitions.add(fieldDefinitionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Field definitions in the template; a field is comprised of a key/value pair")
    @JsonProperty(value="FieldDefinitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FormFieldDefinition> getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    public void setFieldDefinitions(List<FormFieldDefinition> fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
    }

    public FormDefinitionTemplate tableDefinitions(List<FormTableDefinition> tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
        return this;
    }

    public FormDefinitionTemplate addTableDefinitionsItem(FormTableDefinition tableDefinitionsItem) {
        if (this.tableDefinitions == null) {
            this.tableDefinitions = new ArrayList<FormTableDefinition>();
        }
        this.tableDefinitions.add(tableDefinitionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Table definitions in the template; a table is comprised of columns and rows and exists in a 2-dimensional layout; a common example of a table would be an invoice")
    @JsonProperty(value="TableDefinitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FormTableDefinition> getTableDefinitions() {
        return this.tableDefinitions;
    }

    public void setTableDefinitions(List<FormTableDefinition> tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormDefinitionTemplate formDefinitionTemplate = (FormDefinitionTemplate)o;
        return Objects.equals(this.fieldDefinitions, formDefinitionTemplate.fieldDefinitions) && Objects.equals(this.tableDefinitions, formDefinitionTemplate.tableDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.fieldDefinitions, this.tableDefinitions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormDefinitionTemplate {\n");
        sb.append("    fieldDefinitions: ").append(this.toIndentedString(this.fieldDefinitions)).append("\n");
        sb.append("    tableDefinitions: ").append(this.toIndentedString(this.tableDefinitions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

