/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.FineTextItem;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of an operation to detect text in a photo")
@JsonPropertyOrder(value={"Successful", "TextItems", "TextItemsCount"})
@JsonTypeName(value="FineTextDetectionResult")
public class FineTextDetectionResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_TEXT_ITEMS = "TextItems";
    private List<FineTextItem> textItems = null;
    public static final String JSON_PROPERTY_TEXT_ITEMS_COUNT = "TextItemsCount";
    private Integer textItemsCount;

    public FineTextDetectionResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public FineTextDetectionResult textItems(List<FineTextItem> textItems) {
        this.textItems = textItems;
        return this;
    }

    public FineTextDetectionResult addTextItemsItem(FineTextItem textItemsItem) {
        if (this.textItems == null) {
            this.textItems = new ArrayList<FineTextItem>();
        }
        this.textItems.add(textItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text items found in the input image")
    @JsonProperty(value="TextItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FineTextItem> getTextItems() {
        return this.textItems;
    }

    public void setTextItems(List<FineTextItem> textItems) {
        this.textItems = textItems;
    }

    public FineTextDetectionResult textItemsCount(Integer textItemsCount) {
        this.textItemsCount = textItemsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count of text items found in the input image")
    @JsonProperty(value="TextItemsCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTextItemsCount() {
        return this.textItemsCount;
    }

    public void setTextItemsCount(Integer textItemsCount) {
        this.textItemsCount = textItemsCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FineTextDetectionResult fineTextDetectionResult = (FineTextDetectionResult)o;
        return Objects.equals(this.successful, fineTextDetectionResult.successful) && Objects.equals(this.textItems, fineTextDetectionResult.textItems) && Objects.equals(this.textItemsCount, fineTextDetectionResult.textItemsCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.textItems, this.textItemsCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FineTextDetectionResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    textItems: ").append(this.toIndentedString(this.textItems)).append("\n");
        sb.append("    textItemsCount: ").append(this.toIndentedString(this.textItemsCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

