/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of a find symbol operation on an input image")
@JsonPropertyOrder(value={"Successful", "MatchScore", "XLeft", "YTop", "Width", "Height"})
@JsonTypeName(value="FindSymbolResult")
public class FindSymbolResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_MATCH_SCORE = "MatchScore";
    private Double matchScore;
    public static final String JSON_PROPERTY_XLEFT = "XLeft";
    private Integer xleft;
    public static final String JSON_PROPERTY_YTOP = "YTop";
    private Integer ytop;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Integer height;

    public FindSymbolResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public FindSymbolResult matchScore(Double matchScore) {
        this.matchScore = matchScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Score between 0.0 and 1.0 that measures how closely the symbol matched; scores above 0.2 are good")
    @JsonProperty(value="MatchScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getMatchScore() {
        return this.matchScore;
    }

    public void setMatchScore(Double matchScore) {
        this.matchScore = matchScore;
    }

    public FindSymbolResult xleft(Integer xleft) {
        this.xleft = xleft;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X location of the left edge of the found location in pixels")
    @JsonProperty(value="XLeft")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getXleft() {
        return this.xleft;
    }

    public void setXleft(Integer xleft) {
        this.xleft = xleft;
    }

    public FindSymbolResult ytop(Integer ytop) {
        this.ytop = ytop;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y location of the top edge of the found location in pixels")
    @JsonProperty(value="YTop")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getYtop() {
        return this.ytop;
    }

    public void setYtop(Integer ytop) {
        this.ytop = ytop;
    }

    public FindSymbolResult width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width of the found location in pixels")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public FindSymbolResult height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height of the found location in pixels")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindSymbolResult findSymbolResult = (FindSymbolResult)o;
        return Objects.equals(this.successful, findSymbolResult.successful) && Objects.equals(this.matchScore, findSymbolResult.matchScore) && Objects.equals(this.xleft, findSymbolResult.xleft) && Objects.equals(this.ytop, findSymbolResult.ytop) && Objects.equals(this.width, findSymbolResult.width) && Objects.equals(this.height, findSymbolResult.height);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.matchScore, this.xleft, this.ytop, this.width, this.height);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FindSymbolResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    matchScore: ").append(this.toIndentedString(this.matchScore)).append("\n");
        sb.append("    xleft: ").append(this.toIndentedString(this.xleft)).append("\n");
        sb.append("    ytop: ").append(this.toIndentedString(this.ytop)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

