/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.FacePoint;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Location of one face in an image")
@JsonPropertyOrder(value={"LeftX", "TopY", "RightX", "BottomY", "LeftEyebrow", "RightEyebrow", "LeftEye", "RightEye", "BottomAndSidesOfFace", "NoseBridge", "NoseBottom", "LipsInnerOutline", "LipsOuterOutline"})
@JsonTypeName(value="FaceWithLandmarks")
public class FaceWithLandmarks {
    public static final String JSON_PROPERTY_LEFT_X = "LeftX";
    private Integer leftX;
    public static final String JSON_PROPERTY_TOP_Y = "TopY";
    private Integer topY;
    public static final String JSON_PROPERTY_RIGHT_X = "RightX";
    private Integer rightX;
    public static final String JSON_PROPERTY_BOTTOM_Y = "BottomY";
    private Integer bottomY;
    public static final String JSON_PROPERTY_LEFT_EYEBROW = "LeftEyebrow";
    private List<FacePoint> leftEyebrow = null;
    public static final String JSON_PROPERTY_RIGHT_EYEBROW = "RightEyebrow";
    private List<FacePoint> rightEyebrow = null;
    public static final String JSON_PROPERTY_LEFT_EYE = "LeftEye";
    private List<FacePoint> leftEye = null;
    public static final String JSON_PROPERTY_RIGHT_EYE = "RightEye";
    private List<FacePoint> rightEye = null;
    public static final String JSON_PROPERTY_BOTTOM_AND_SIDES_OF_FACE = "BottomAndSidesOfFace";
    private List<FacePoint> bottomAndSidesOfFace = null;
    public static final String JSON_PROPERTY_NOSE_BRIDGE = "NoseBridge";
    private List<FacePoint> noseBridge = null;
    public static final String JSON_PROPERTY_NOSE_BOTTOM = "NoseBottom";
    private List<FacePoint> noseBottom = null;
    public static final String JSON_PROPERTY_LIPS_INNER_OUTLINE = "LipsInnerOutline";
    private List<FacePoint> lipsInnerOutline = null;
    public static final String JSON_PROPERTY_LIPS_OUTER_OUTLINE = "LipsOuterOutline";
    private List<FacePoint> lipsOuterOutline = null;

    public FaceWithLandmarks leftX(Integer leftX) {
        this.leftX = leftX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X coordinate of the left side of the face")
    @JsonProperty(value="LeftX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLeftX() {
        return this.leftX;
    }

    public void setLeftX(Integer leftX) {
        this.leftX = leftX;
    }

    public FaceWithLandmarks topY(Integer topY) {
        this.topY = topY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y coordinate of the top side of the face")
    @JsonProperty(value="TopY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTopY() {
        return this.topY;
    }

    public void setTopY(Integer topY) {
        this.topY = topY;
    }

    public FaceWithLandmarks rightX(Integer rightX) {
        this.rightX = rightX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X coordinate of the right side of the face")
    @JsonProperty(value="RightX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRightX() {
        return this.rightX;
    }

    public void setRightX(Integer rightX) {
        this.rightX = rightX;
    }

    public FaceWithLandmarks bottomY(Integer bottomY) {
        this.bottomY = bottomY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y coordinate of the bottom side of the face")
    @JsonProperty(value="BottomY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBottomY() {
        return this.bottomY;
    }

    public void setBottomY(Integer bottomY) {
        this.bottomY = bottomY;
    }

    public FaceWithLandmarks leftEyebrow(List<FacePoint> leftEyebrow) {
        this.leftEyebrow = leftEyebrow;
        return this;
    }

    public FaceWithLandmarks addLeftEyebrowItem(FacePoint leftEyebrowItem) {
        if (this.leftEyebrow == null) {
            this.leftEyebrow = new ArrayList<FacePoint>();
        }
        this.leftEyebrow.add(leftEyebrowItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Point locations of the left eyebrow (the eyebrow cloesest to the left side of the picture)")
    @JsonProperty(value="LeftEyebrow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FacePoint> getLeftEyebrow() {
        return this.leftEyebrow;
    }

    public void setLeftEyebrow(List<FacePoint> leftEyebrow) {
        this.leftEyebrow = leftEyebrow;
    }

    public FaceWithLandmarks rightEyebrow(List<FacePoint> rightEyebrow) {
        this.rightEyebrow = rightEyebrow;
        return this;
    }

    public FaceWithLandmarks addRightEyebrowItem(FacePoint rightEyebrowItem) {
        if (this.rightEyebrow == null) {
            this.rightEyebrow = new ArrayList<FacePoint>();
        }
        this.rightEyebrow.add(rightEyebrowItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Point locations of the right eyebrow (the eyebrow cloesest to the right side of the picture)")
    @JsonProperty(value="RightEyebrow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FacePoint> getRightEyebrow() {
        return this.rightEyebrow;
    }

    public void setRightEyebrow(List<FacePoint> rightEyebrow) {
        this.rightEyebrow = rightEyebrow;
    }

    public FaceWithLandmarks leftEye(List<FacePoint> leftEye) {
        this.leftEye = leftEye;
        return this;
    }

    public FaceWithLandmarks addLeftEyeItem(FacePoint leftEyeItem) {
        if (this.leftEye == null) {
            this.leftEye = new ArrayList<FacePoint>();
        }
        this.leftEye.add(leftEyeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Point locations of the left eye (the eye closest to the left side of the picture)")
    @JsonProperty(value="LeftEye")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FacePoint> getLeftEye() {
        return this.leftEye;
    }

    public void setLeftEye(List<FacePoint> leftEye) {
        this.leftEye = leftEye;
    }

    public FaceWithLandmarks rightEye(List<FacePoint> rightEye) {
        this.rightEye = rightEye;
        return this;
    }

    public FaceWithLandmarks addRightEyeItem(FacePoint rightEyeItem) {
        if (this.rightEye == null) {
            this.rightEye = new ArrayList<FacePoint>();
        }
        this.rightEye.add(rightEyeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Point locations of the right eye (the eye closest to the right side of the picture)")
    @JsonProperty(value="RightEye")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FacePoint> getRightEye() {
        return this.rightEye;
    }

    public void setRightEye(List<FacePoint> rightEye) {
        this.rightEye = rightEye;
    }

    public FaceWithLandmarks bottomAndSidesOfFace(List<FacePoint> bottomAndSidesOfFace) {
        this.bottomAndSidesOfFace = bottomAndSidesOfFace;
        return this;
    }

    public FaceWithLandmarks addBottomAndSidesOfFaceItem(FacePoint bottomAndSidesOfFaceItem) {
        if (this.bottomAndSidesOfFace == null) {
            this.bottomAndSidesOfFace = new ArrayList<FacePoint>();
        }
        this.bottomAndSidesOfFace.add(bottomAndSidesOfFaceItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Point locations of the bottom and sides of the face (cheeks and chin)")
    @JsonProperty(value="BottomAndSidesOfFace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FacePoint> getBottomAndSidesOfFace() {
        return this.bottomAndSidesOfFace;
    }

    public void setBottomAndSidesOfFace(List<FacePoint> bottomAndSidesOfFace) {
        this.bottomAndSidesOfFace = bottomAndSidesOfFace;
    }

    public FaceWithLandmarks noseBridge(List<FacePoint> noseBridge) {
        this.noseBridge = noseBridge;
        return this;
    }

    public FaceWithLandmarks addNoseBridgeItem(FacePoint noseBridgeItem) {
        if (this.noseBridge == null) {
            this.noseBridge = new ArrayList<FacePoint>();
        }
        this.noseBridge.add(noseBridgeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Point locations of the nose bridge (the vertical portion of the nose)")
    @JsonProperty(value="NoseBridge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FacePoint> getNoseBridge() {
        return this.noseBridge;
    }

    public void setNoseBridge(List<FacePoint> noseBridge) {
        this.noseBridge = noseBridge;
    }

    public FaceWithLandmarks noseBottom(List<FacePoint> noseBottom) {
        this.noseBottom = noseBottom;
        return this;
    }

    public FaceWithLandmarks addNoseBottomItem(FacePoint noseBottomItem) {
        if (this.noseBottom == null) {
            this.noseBottom = new ArrayList<FacePoint>();
        }
        this.noseBottom.add(noseBottomItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Point locations of the bottom (nostrils) of the nose")
    @JsonProperty(value="NoseBottom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FacePoint> getNoseBottom() {
        return this.noseBottom;
    }

    public void setNoseBottom(List<FacePoint> noseBottom) {
        this.noseBottom = noseBottom;
    }

    public FaceWithLandmarks lipsInnerOutline(List<FacePoint> lipsInnerOutline) {
        this.lipsInnerOutline = lipsInnerOutline;
        return this;
    }

    public FaceWithLandmarks addLipsInnerOutlineItem(FacePoint lipsInnerOutlineItem) {
        if (this.lipsInnerOutline == null) {
            this.lipsInnerOutline = new ArrayList<FacePoint>();
        }
        this.lipsInnerOutline.add(lipsInnerOutlineItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Point locations of the inner outline of the lips")
    @JsonProperty(value="LipsInnerOutline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FacePoint> getLipsInnerOutline() {
        return this.lipsInnerOutline;
    }

    public void setLipsInnerOutline(List<FacePoint> lipsInnerOutline) {
        this.lipsInnerOutline = lipsInnerOutline;
    }

    public FaceWithLandmarks lipsOuterOutline(List<FacePoint> lipsOuterOutline) {
        this.lipsOuterOutline = lipsOuterOutline;
        return this;
    }

    public FaceWithLandmarks addLipsOuterOutlineItem(FacePoint lipsOuterOutlineItem) {
        if (this.lipsOuterOutline == null) {
            this.lipsOuterOutline = new ArrayList<FacePoint>();
        }
        this.lipsOuterOutline.add(lipsOuterOutlineItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Point locations of the outer outline of the lips")
    @JsonProperty(value="LipsOuterOutline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FacePoint> getLipsOuterOutline() {
        return this.lipsOuterOutline;
    }

    public void setLipsOuterOutline(List<FacePoint> lipsOuterOutline) {
        this.lipsOuterOutline = lipsOuterOutline;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaceWithLandmarks faceWithLandmarks = (FaceWithLandmarks)o;
        return Objects.equals(this.leftX, faceWithLandmarks.leftX) && Objects.equals(this.topY, faceWithLandmarks.topY) && Objects.equals(this.rightX, faceWithLandmarks.rightX) && Objects.equals(this.bottomY, faceWithLandmarks.bottomY) && Objects.equals(this.leftEyebrow, faceWithLandmarks.leftEyebrow) && Objects.equals(this.rightEyebrow, faceWithLandmarks.rightEyebrow) && Objects.equals(this.leftEye, faceWithLandmarks.leftEye) && Objects.equals(this.rightEye, faceWithLandmarks.rightEye) && Objects.equals(this.bottomAndSidesOfFace, faceWithLandmarks.bottomAndSidesOfFace) && Objects.equals(this.noseBridge, faceWithLandmarks.noseBridge) && Objects.equals(this.noseBottom, faceWithLandmarks.noseBottom) && Objects.equals(this.lipsInnerOutline, faceWithLandmarks.lipsInnerOutline) && Objects.equals(this.lipsOuterOutline, faceWithLandmarks.lipsOuterOutline);
    }

    public int hashCode() {
        return Objects.hash(this.leftX, this.topY, this.rightX, this.bottomY, this.leftEyebrow, this.rightEyebrow, this.leftEye, this.rightEye, this.bottomAndSidesOfFace, this.noseBridge, this.noseBottom, this.lipsInnerOutline, this.lipsOuterOutline);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaceWithLandmarks {\n");
        sb.append("    leftX: ").append(this.toIndentedString(this.leftX)).append("\n");
        sb.append("    topY: ").append(this.toIndentedString(this.topY)).append("\n");
        sb.append("    rightX: ").append(this.toIndentedString(this.rightX)).append("\n");
        sb.append("    bottomY: ").append(this.toIndentedString(this.bottomY)).append("\n");
        sb.append("    leftEyebrow: ").append(this.toIndentedString(this.leftEyebrow)).append("\n");
        sb.append("    rightEyebrow: ").append(this.toIndentedString(this.rightEyebrow)).append("\n");
        sb.append("    leftEye: ").append(this.toIndentedString(this.leftEye)).append("\n");
        sb.append("    rightEye: ").append(this.toIndentedString(this.rightEye)).append("\n");
        sb.append("    bottomAndSidesOfFace: ").append(this.toIndentedString(this.bottomAndSidesOfFace)).append("\n");
        sb.append("    noseBridge: ").append(this.toIndentedString(this.noseBridge)).append("\n");
        sb.append("    noseBottom: ").append(this.toIndentedString(this.noseBottom)).append("\n");
        sb.append("    lipsInnerOutline: ").append(this.toIndentedString(this.lipsInnerOutline)).append("\n");
        sb.append("    lipsOuterOutline: ").append(this.toIndentedString(this.lipsOuterOutline)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

