/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.Face;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Results of locating faces in an image")
@JsonPropertyOrder(value={"Successful", "Faces", "FaceCount", "ErrorDetails"})
@JsonTypeName(value="FaceLocateResponse")
public class FaceLocateResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_FACES = "Faces";
    private List<Face> faces = null;
    public static final String JSON_PROPERTY_FACE_COUNT = "FaceCount";
    private Integer faceCount;
    public static final String JSON_PROPERTY_ERROR_DETAILS = "ErrorDetails";
    private String errorDetails;

    public FaceLocateResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public FaceLocateResponse faces(List<Face> faces) {
        this.faces = faces;
        return this;
    }

    public FaceLocateResponse addFacesItem(Face facesItem) {
        if (this.faces == null) {
            this.faces = new ArrayList<Face>();
        }
        this.faces.add(facesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of faces found in the image")
    @JsonProperty(value="Faces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Face> getFaces() {
        return this.faces;
    }

    public void setFaces(List<Face> faces) {
        this.faces = faces;
    }

    public FaceLocateResponse faceCount(Integer faceCount) {
        this.faceCount = faceCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of faces found in the image")
    @JsonProperty(value="FaceCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFaceCount() {
        return this.faceCount;
    }

    public void setFaceCount(Integer faceCount) {
        this.faceCount = faceCount;
    }

    public FaceLocateResponse errorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details of any errors that occurred")
    @JsonProperty(value="ErrorDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaceLocateResponse faceLocateResponse = (FaceLocateResponse)o;
        return Objects.equals(this.successful, faceLocateResponse.successful) && Objects.equals(this.faces, faceLocateResponse.faces) && Objects.equals(this.faceCount, faceLocateResponse.faceCount) && Objects.equals(this.errorDetails, faceLocateResponse.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.faces, this.faceCount, this.errorDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaceLocateResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    faces: ").append(this.toIndentedString(this.faces)).append("\n");
        sb.append("    faceCount: ").append(this.toIndentedString(this.faceCount)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

