/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Location of one face in an image")
@JsonPropertyOrder(value={"LeftX", "TopY", "RightX", "BottomY"})
@JsonTypeName(value="Face")
public class Face {
    public static final String JSON_PROPERTY_LEFT_X = "LeftX";
    private Integer leftX;
    public static final String JSON_PROPERTY_TOP_Y = "TopY";
    private Integer topY;
    public static final String JSON_PROPERTY_RIGHT_X = "RightX";
    private Integer rightX;
    public static final String JSON_PROPERTY_BOTTOM_Y = "BottomY";
    private Integer bottomY;

    public Face leftX(Integer leftX) {
        this.leftX = leftX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X coordinate of the left side of the face")
    @JsonProperty(value="LeftX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLeftX() {
        return this.leftX;
    }

    public void setLeftX(Integer leftX) {
        this.leftX = leftX;
    }

    public Face topY(Integer topY) {
        this.topY = topY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y coordinate of the top side of the face")
    @JsonProperty(value="TopY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTopY() {
        return this.topY;
    }

    public void setTopY(Integer topY) {
        this.topY = topY;
    }

    public Face rightX(Integer rightX) {
        this.rightX = rightX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X coordinate of the right side of the face")
    @JsonProperty(value="RightX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRightX() {
        return this.rightX;
    }

    public void setRightX(Integer rightX) {
        this.rightX = rightX;
    }

    public Face bottomY(Integer bottomY) {
        this.bottomY = bottomY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y coordinate of the bottom side of the face")
    @JsonProperty(value="BottomY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBottomY() {
        return this.bottomY;
    }

    public void setBottomY(Integer bottomY) {
        this.bottomY = bottomY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Face face = (Face)o;
        return Objects.equals(this.leftX, face.leftX) && Objects.equals(this.topY, face.topY) && Objects.equals(this.rightX, face.rightX) && Objects.equals(this.bottomY, face.bottomY);
    }

    public int hashCode() {
        return Objects.hash(this.leftX, this.topY, this.rightX, this.bottomY);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Face {\n");
        sb.append("    leftX: ").append(this.toIndentedString(this.leftX)).append("\n");
        sb.append("    topY: ").append(this.toIndentedString(this.topY)).append("\n");
        sb.append("    rightX: ").append(this.toIndentedString(this.rightX)).append("\n");
        sb.append("    bottomY: ").append(this.toIndentedString(this.bottomY)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

