/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.EmlAttachment;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of converting an EML file to HTML string")
@JsonPropertyOrder(value={"Successful", "Content", "Body", "From", "To", "Cc", "DateSent", "Subject", "Attachments"})
@JsonTypeName(value="EmlToHtmlResult")
public class EmlToHtmlResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_CONTENT = "Content";
    private String content;
    public static final String JSON_PROPERTY_BODY = "Body";
    private String body;
    public static final String JSON_PROPERTY_FROM = "From";
    private String from;
    public static final String JSON_PROPERTY_TO = "To";
    private String to;
    public static final String JSON_PROPERTY_CC = "Cc";
    private String cc;
    public static final String JSON_PROPERTY_DATE_SENT = "DateSent";
    private String dateSent;
    public static final String JSON_PROPERTY_SUBJECT = "Subject";
    private String subject;
    public static final String JSON_PROPERTY_ATTACHMENTS = "Attachments";
    private List<EmlAttachment> attachments = null;

    public EmlToHtmlResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public EmlToHtmlResult content(String content) {
        this.content = content;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An HTML string version of the EML file")
    @JsonProperty(value="Content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public EmlToHtmlResult body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The main body of the EML file's email as an HTML string")
    @JsonProperty(value="Body")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public EmlToHtmlResult from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The From sender of the EML file's email")
    @JsonProperty(value="From")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public EmlToHtmlResult to(String to) {
        this.to = to;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The To recipients of the EML file's email")
    @JsonProperty(value="To")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public EmlToHtmlResult cc(String cc) {
        this.cc = cc;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The CC recipients of the EML file's email")
    @JsonProperty(value="Cc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public EmlToHtmlResult dateSent(String dateSent) {
        this.dateSent = dateSent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time that the EML file's email was sent")
    @JsonProperty(value="DateSent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDateSent() {
        return this.dateSent;
    }

    public void setDateSent(String dateSent) {
        this.dateSent = dateSent;
    }

    public EmlToHtmlResult subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The subject of the EML file's email")
    @JsonProperty(value="Subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmlToHtmlResult attachments(List<EmlAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public EmlToHtmlResult addAttachmentsItem(EmlAttachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<EmlAttachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of all attachments for the EML file")
    @JsonProperty(value="Attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EmlAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<EmlAttachment> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmlToHtmlResult emlToHtmlResult = (EmlToHtmlResult)o;
        return Objects.equals(this.successful, emlToHtmlResult.successful) && Objects.equals(this.content, emlToHtmlResult.content) && Objects.equals(this.body, emlToHtmlResult.body) && Objects.equals(this.from, emlToHtmlResult.from) && Objects.equals(this.to, emlToHtmlResult.to) && Objects.equals(this.cc, emlToHtmlResult.cc) && Objects.equals(this.dateSent, emlToHtmlResult.dateSent) && Objects.equals(this.subject, emlToHtmlResult.subject) && Objects.equals(this.attachments, emlToHtmlResult.attachments);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.content, this.body, this.from, this.to, this.cc, this.dateSent, this.subject, this.attachments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmlToHtmlResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    dateSent: ").append(this.toIndentedString(this.dateSent)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

