/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DrawRectangleInstance;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to draw one or more rectangles on a base image")
@JsonPropertyOrder(value={"BaseImageBytes", "BaseImageUrl", "RectanglesToDraw"})
@JsonTypeName(value="DrawRectangleRequest")
public class DrawRectangleRequest {
    public static final String JSON_PROPERTY_BASE_IMAGE_BYTES = "BaseImageBytes";
    private byte[] baseImageBytes;
    public static final String JSON_PROPERTY_BASE_IMAGE_URL = "BaseImageUrl";
    private String baseImageUrl;
    public static final String JSON_PROPERTY_RECTANGLES_TO_DRAW = "RectanglesToDraw";
    private List<DrawRectangleInstance> rectanglesToDraw = null;

    public DrawRectangleRequest baseImageBytes(byte[] baseImageBytes) {
        this.baseImageBytes = baseImageBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image to draw rectangles on, in bytes.  You can also use the BaseImageUrl instead to supply image input as a URL")
    @JsonProperty(value="BaseImageBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getBaseImageBytes() {
        return this.baseImageBytes;
    }

    public void setBaseImageBytes(byte[] baseImageBytes) {
        this.baseImageBytes = baseImageBytes;
    }

    public DrawRectangleRequest baseImageUrl(String baseImageUrl) {
        this.baseImageUrl = baseImageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image to draw rectangles on, as an HTTP or HTTPS fully-qualified URL")
    @JsonProperty(value="BaseImageUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBaseImageUrl() {
        return this.baseImageUrl;
    }

    public void setBaseImageUrl(String baseImageUrl) {
        this.baseImageUrl = baseImageUrl;
    }

    public DrawRectangleRequest rectanglesToDraw(List<DrawRectangleInstance> rectanglesToDraw) {
        this.rectanglesToDraw = rectanglesToDraw;
        return this;
    }

    public DrawRectangleRequest addRectanglesToDrawItem(DrawRectangleInstance rectanglesToDrawItem) {
        if (this.rectanglesToDraw == null) {
            this.rectanglesToDraw = new ArrayList<DrawRectangleInstance>();
        }
        this.rectanglesToDraw.add(rectanglesToDrawItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rectangles to draw on the image.  Rectangles are drawn in index order.")
    @JsonProperty(value="RectanglesToDraw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DrawRectangleInstance> getRectanglesToDraw() {
        return this.rectanglesToDraw;
    }

    public void setRectanglesToDraw(List<DrawRectangleInstance> rectanglesToDraw) {
        this.rectanglesToDraw = rectanglesToDraw;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawRectangleRequest drawRectangleRequest = (DrawRectangleRequest)o;
        return Arrays.equals(this.baseImageBytes, drawRectangleRequest.baseImageBytes) && Objects.equals(this.baseImageUrl, drawRectangleRequest.baseImageUrl) && Objects.equals(this.rectanglesToDraw, drawRectangleRequest.rectanglesToDraw);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.baseImageBytes), this.baseImageUrl, this.rectanglesToDraw);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DrawRectangleRequest {\n");
        sb.append("    baseImageBytes: ").append(this.toIndentedString(this.baseImageBytes)).append("\n");
        sb.append("    baseImageUrl: ").append(this.toIndentedString(this.baseImageUrl)).append("\n");
        sb.append("    rectanglesToDraw: ").append(this.toIndentedString(this.rectanglesToDraw)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

