/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DrawPolygonInstance;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to draw one or more polygons on a base image")
@JsonPropertyOrder(value={"BaseImageBytes", "BaseImageUrl", "PolygonsToDraw"})
@JsonTypeName(value="DrawPolygonRequest")
public class DrawPolygonRequest {
    public static final String JSON_PROPERTY_BASE_IMAGE_BYTES = "BaseImageBytes";
    private byte[] baseImageBytes;
    public static final String JSON_PROPERTY_BASE_IMAGE_URL = "BaseImageUrl";
    private String baseImageUrl;
    public static final String JSON_PROPERTY_POLYGONS_TO_DRAW = "PolygonsToDraw";
    private List<DrawPolygonInstance> polygonsToDraw = null;

    public DrawPolygonRequest baseImageBytes(byte[] baseImageBytes) {
        this.baseImageBytes = baseImageBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image to draw polygons on, in bytes.  You can also use the BaseImageUrl instead to supply image input as a URL")
    @JsonProperty(value="BaseImageBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getBaseImageBytes() {
        return this.baseImageBytes;
    }

    public void setBaseImageBytes(byte[] baseImageBytes) {
        this.baseImageBytes = baseImageBytes;
    }

    public DrawPolygonRequest baseImageUrl(String baseImageUrl) {
        this.baseImageUrl = baseImageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image to draw polygons on, as an HTTP or HTTPS fully-qualified URL")
    @JsonProperty(value="BaseImageUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBaseImageUrl() {
        return this.baseImageUrl;
    }

    public void setBaseImageUrl(String baseImageUrl) {
        this.baseImageUrl = baseImageUrl;
    }

    public DrawPolygonRequest polygonsToDraw(List<DrawPolygonInstance> polygonsToDraw) {
        this.polygonsToDraw = polygonsToDraw;
        return this;
    }

    public DrawPolygonRequest addPolygonsToDrawItem(DrawPolygonInstance polygonsToDrawItem) {
        if (this.polygonsToDraw == null) {
            this.polygonsToDraw = new ArrayList<DrawPolygonInstance>();
        }
        this.polygonsToDraw.add(polygonsToDrawItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Polygons to draw on the image.  Polygons are drawn in index order.")
    @JsonProperty(value="PolygonsToDraw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DrawPolygonInstance> getPolygonsToDraw() {
        return this.polygonsToDraw;
    }

    public void setPolygonsToDraw(List<DrawPolygonInstance> polygonsToDraw) {
        this.polygonsToDraw = polygonsToDraw;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawPolygonRequest drawPolygonRequest = (DrawPolygonRequest)o;
        return Arrays.equals(this.baseImageBytes, drawPolygonRequest.baseImageBytes) && Objects.equals(this.baseImageUrl, drawPolygonRequest.baseImageUrl) && Objects.equals(this.polygonsToDraw, drawPolygonRequest.polygonsToDraw);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.baseImageBytes), this.baseImageUrl, this.polygonsToDraw);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DrawPolygonRequest {\n");
        sb.append("    baseImageBytes: ").append(this.toIndentedString(this.baseImageBytes)).append("\n");
        sb.append("    baseImageUrl: ").append(this.toIndentedString(this.baseImageUrl)).append("\n");
        sb.append("    polygonsToDraw: ").append(this.toIndentedString(this.polygonsToDraw)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

