/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.PolygonPoint;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Polygon instance to draw on an image")
@JsonPropertyOrder(value={"BorderColor", "BorderWidth", "FillColor", "Points"})
@JsonTypeName(value="DrawPolygonInstance")
public class DrawPolygonInstance {
    public static final String JSON_PROPERTY_BORDER_COLOR = "BorderColor";
    private String borderColor;
    public static final String JSON_PROPERTY_BORDER_WIDTH = "BorderWidth";
    private Double borderWidth;
    public static final String JSON_PROPERTY_FILL_COLOR = "FillColor";
    private String fillColor;
    public static final String JSON_PROPERTY_POINTS = "Points";
    private List<PolygonPoint> points = null;

    public DrawPolygonInstance borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Border Color to use - can be a hex value (with #) or HTML common color name.  Transparent colors are supported.")
    @JsonProperty(value="BorderColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    public DrawPolygonInstance borderWidth(Double borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width in pixels of the border.  Pass in 0 to draw a polygon with no border")
    @JsonProperty(value="BorderWidth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(Double borderWidth) {
        this.borderWidth = borderWidth;
    }

    public DrawPolygonInstance fillColor(String fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Fill Color to use - can be a hex value (with #) or HTML common color name.  Transparent colors are supported.  Leave blank to not fill the polygon.")
    @JsonProperty(value="FillColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(String fillColor) {
        this.fillColor = fillColor;
    }

    public DrawPolygonInstance points(List<PolygonPoint> points) {
        this.points = points;
        return this;
    }

    public DrawPolygonInstance addPointsItem(PolygonPoint pointsItem) {
        if (this.points == null) {
            this.points = new ArrayList<PolygonPoint>();
        }
        this.points.add(pointsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Points (vertices) which comprise the polygon; valid polygons must have at least 3 points")
    @JsonProperty(value="Points")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PolygonPoint> getPoints() {
        return this.points;
    }

    public void setPoints(List<PolygonPoint> points) {
        this.points = points;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawPolygonInstance drawPolygonInstance = (DrawPolygonInstance)o;
        return Objects.equals(this.borderColor, drawPolygonInstance.borderColor) && Objects.equals(this.borderWidth, drawPolygonInstance.borderWidth) && Objects.equals(this.fillColor, drawPolygonInstance.fillColor) && Objects.equals(this.points, drawPolygonInstance.points);
    }

    public int hashCode() {
        return Objects.hash(this.borderColor, this.borderWidth, this.fillColor, this.points);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DrawPolygonInstance {\n");
        sb.append("    borderColor: ").append(this.toIndentedString(this.borderColor)).append("\n");
        sb.append("    borderWidth: ").append(this.toIndentedString(this.borderWidth)).append("\n");
        sb.append("    fillColor: ").append(this.toIndentedString(this.fillColor)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

