/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxParagraph;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A cell in a Word Document (DOCX) file")
@JsonPropertyOrder(value={"CellIndex", "Path", "Paragraphs", "CellShadingColor", "CellShadingFill", "CellShadingPattern", "CellWidthMode", "CellWidth"})
@JsonTypeName(value="DocxTableCell")
public class DocxTableCell {
    public static final String JSON_PROPERTY_CELL_INDEX = "CellIndex";
    private Integer cellIndex;
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;
    public static final String JSON_PROPERTY_PARAGRAPHS = "Paragraphs";
    private List<DocxParagraph> paragraphs = null;
    public static final String JSON_PROPERTY_CELL_SHADING_COLOR = "CellShadingColor";
    private String cellShadingColor;
    public static final String JSON_PROPERTY_CELL_SHADING_FILL = "CellShadingFill";
    private String cellShadingFill;
    public static final String JSON_PROPERTY_CELL_SHADING_PATTERN = "CellShadingPattern";
    private String cellShadingPattern;
    public static final String JSON_PROPERTY_CELL_WIDTH_MODE = "CellWidthMode";
    private String cellWidthMode;
    public static final String JSON_PROPERTY_CELL_WIDTH = "CellWidth";
    private String cellWidth;

    public DocxTableCell cellIndex(Integer cellIndex) {
        this.cellIndex = cellIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The index of the cell, 0-based")
    @JsonProperty(value="CellIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCellIndex() {
        return this.cellIndex;
    }

    public void setCellIndex(Integer cellIndex) {
        this.cellIndex = cellIndex;
    }

    public DocxTableCell path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Path of the location of this object; leave blank for new tables")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DocxTableCell paragraphs(List<DocxParagraph> paragraphs) {
        this.paragraphs = paragraphs;
        return this;
    }

    public DocxTableCell addParagraphsItem(DocxParagraph paragraphsItem) {
        if (this.paragraphs == null) {
            this.paragraphs = new ArrayList<DocxParagraph>();
        }
        this.paragraphs.add(paragraphsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Paragraphs inside the cell; this is where the contents of the cell are stored")
    @JsonProperty(value="Paragraphs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocxParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public void setParagraphs(List<DocxParagraph> paragraphs) {
        this.paragraphs = paragraphs;
    }

    public DocxTableCell cellShadingColor(String cellShadingColor) {
        this.cellShadingColor = cellShadingColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Color of the cell shading")
    @JsonProperty(value="CellShadingColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCellShadingColor() {
        return this.cellShadingColor;
    }

    public void setCellShadingColor(String cellShadingColor) {
        this.cellShadingColor = cellShadingColor;
    }

    public DocxTableCell cellShadingFill(String cellShadingFill) {
        this.cellShadingFill = cellShadingFill;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Fill of the cell shading")
    @JsonProperty(value="CellShadingFill")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCellShadingFill() {
        return this.cellShadingFill;
    }

    public void setCellShadingFill(String cellShadingFill) {
        this.cellShadingFill = cellShadingFill;
    }

    public DocxTableCell cellShadingPattern(String cellShadingPattern) {
        this.cellShadingPattern = cellShadingPattern;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pattern of the cell shading")
    @JsonProperty(value="CellShadingPattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCellShadingPattern() {
        return this.cellShadingPattern;
    }

    public void setCellShadingPattern(String cellShadingPattern) {
        this.cellShadingPattern = cellShadingPattern;
    }

    public DocxTableCell cellWidthMode(String cellWidthMode) {
        this.cellWidthMode = cellWidthMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width mode of the cell; can be auto (for automatic) or manual")
    @JsonProperty(value="CellWidthMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCellWidthMode() {
        return this.cellWidthMode;
    }

    public void setCellWidthMode(String cellWidthMode) {
        this.cellWidthMode = cellWidthMode;
    }

    public DocxTableCell cellWidth(String cellWidth) {
        this.cellWidth = cellWidth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width of the cell")
    @JsonProperty(value="CellWidth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(String cellWidth) {
        this.cellWidth = cellWidth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxTableCell docxTableCell = (DocxTableCell)o;
        return Objects.equals(this.cellIndex, docxTableCell.cellIndex) && Objects.equals(this.path, docxTableCell.path) && Objects.equals(this.paragraphs, docxTableCell.paragraphs) && Objects.equals(this.cellShadingColor, docxTableCell.cellShadingColor) && Objects.equals(this.cellShadingFill, docxTableCell.cellShadingFill) && Objects.equals(this.cellShadingPattern, docxTableCell.cellShadingPattern) && Objects.equals(this.cellWidthMode, docxTableCell.cellWidthMode) && Objects.equals(this.cellWidth, docxTableCell.cellWidth);
    }

    public int hashCode() {
        return Objects.hash(this.cellIndex, this.path, this.paragraphs, this.cellShadingColor, this.cellShadingFill, this.cellShadingPattern, this.cellWidthMode, this.cellWidth);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxTableCell {\n");
        sb.append("    cellIndex: ").append(this.toIndentedString(this.cellIndex)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    paragraphs: ").append(this.toIndentedString(this.paragraphs)).append("\n");
        sb.append("    cellShadingColor: ").append(this.toIndentedString(this.cellShadingColor)).append("\n");
        sb.append("    cellShadingFill: ").append(this.toIndentedString(this.cellShadingFill)).append("\n");
        sb.append("    cellShadingPattern: ").append(this.toIndentedString(this.cellShadingPattern)).append("\n");
        sb.append("    cellWidthMode: ").append(this.toIndentedString(this.cellWidthMode)).append("\n");
        sb.append("    cellWidth: ").append(this.toIndentedString(this.cellWidth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

