/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Section of a Word Document (DOCX)")
@JsonPropertyOrder(value={"StartingPageNumbers", "Path"})
@JsonTypeName(value="DocxSection")
public class DocxSection {
    public static final String JSON_PROPERTY_STARTING_PAGE_NUMBERS = "StartingPageNumbers";
    private List<Integer> startingPageNumbers = null;
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;

    public DocxSection startingPageNumbers(List<Integer> startingPageNumbers) {
        this.startingPageNumbers = startingPageNumbers;
        return this;
    }

    public DocxSection addStartingPageNumbersItem(Integer startingPageNumbersItem) {
        if (this.startingPageNumbers == null) {
            this.startingPageNumbers = new ArrayList<Integer>();
        }
        this.startingPageNumbers.add(startingPageNumbersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Page numbers that the section starts at, typically just one")
    @JsonProperty(value="StartingPageNumbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Integer> getStartingPageNumbers() {
        return this.startingPageNumbers;
    }

    public void setStartingPageNumbers(List<Integer> startingPageNumbers) {
        this.startingPageNumbers = startingPageNumbers;
    }

    public DocxSection path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Path of the location of this object; leave blank for new tables")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxSection docxSection = (DocxSection)o;
        return Objects.equals(this.startingPageNumbers, docxSection.startingPageNumbers) && Objects.equals(this.path, docxSection.path);
    }

    public int hashCode() {
        return Objects.hash(this.startingPageNumbers, this.path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxSection {\n");
        sb.append("    startingPageNumbers: ").append(this.toIndentedString(this.startingPageNumbers)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

