/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Insert Paragraph request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "PathToObjectToRemove"})
@JsonTypeName(value="DocxRemoveObjectRequest")
public class DocxRemoveObjectRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_PATH_TO_OBJECT_TO_REMOVE = "PathToObjectToRemove";
    private String pathToObjectToRemove;

    public DocxRemoveObjectRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public DocxRemoveObjectRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public DocxRemoveObjectRequest pathToObjectToRemove(String pathToObjectToRemove) {
        this.pathToObjectToRemove = pathToObjectToRemove;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path within the document of the object to delete; fill in the PathToObjectToRemove field using the Path value from an existing object.")
    @JsonProperty(value="PathToObjectToRemove")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPathToObjectToRemove() {
        return this.pathToObjectToRemove;
    }

    public void setPathToObjectToRemove(String pathToObjectToRemove) {
        this.pathToObjectToRemove = pathToObjectToRemove;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxRemoveObjectRequest docxRemoveObjectRequest = (DocxRemoveObjectRequest)o;
        return Arrays.equals(this.inputFileBytes, docxRemoveObjectRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, docxRemoveObjectRequest.inputFileUrl) && Objects.equals(this.pathToObjectToRemove, docxRemoveObjectRequest.pathToObjectToRemove);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.pathToObjectToRemove);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxRemoveObjectRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    pathToObjectToRemove: ").append(this.toIndentedString(this.pathToObjectToRemove)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

