/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxComment;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Insert Comment on Paragraph request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "ParagraphPath", "CommentToInsert"})
@JsonTypeName(value="DocxInsertCommentOnParagraphRequest")
public class DocxInsertCommentOnParagraphRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_PARAGRAPH_PATH = "ParagraphPath";
    private String paragraphPath;
    public static final String JSON_PROPERTY_COMMENT_TO_INSERT = "CommentToInsert";
    private DocxComment commentToInsert;

    public DocxInsertCommentOnParagraphRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public DocxInsertCommentOnParagraphRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public DocxInsertCommentOnParagraphRequest paragraphPath(String paragraphPath) {
        this.paragraphPath = paragraphPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to the paragraph to attach the comment to.  You can get the Path by retrieving all of the Paragraphs in document by calling Get Body and taking the Path property of the desired paragraph to add the comment to.")
    @JsonProperty(value="ParagraphPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParagraphPath() {
        return this.paragraphPath;
    }

    public void setParagraphPath(String paragraphPath) {
        this.paragraphPath = paragraphPath;
    }

    public DocxInsertCommentOnParagraphRequest commentToInsert(DocxComment commentToInsert) {
        this.commentToInsert = commentToInsert;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="CommentToInsert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DocxComment getCommentToInsert() {
        return this.commentToInsert;
    }

    public void setCommentToInsert(DocxComment commentToInsert) {
        this.commentToInsert = commentToInsert;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxInsertCommentOnParagraphRequest docxInsertCommentOnParagraphRequest = (DocxInsertCommentOnParagraphRequest)o;
        return Arrays.equals(this.inputFileBytes, docxInsertCommentOnParagraphRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, docxInsertCommentOnParagraphRequest.inputFileUrl) && Objects.equals(this.paragraphPath, docxInsertCommentOnParagraphRequest.paragraphPath) && Objects.equals(this.commentToInsert, docxInsertCommentOnParagraphRequest.commentToInsert);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.paragraphPath, this.commentToInsert);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxInsertCommentOnParagraphRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    paragraphPath: ").append(this.toIndentedString(this.paragraphPath)).append("\n");
        sb.append("    commentToInsert: ").append(this.toIndentedString(this.commentToInsert)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

