/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxParagraph;
import com.cloudmersive.client.rt.model.DocxSection;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Header of a Word Document (DOCX)")
@JsonPropertyOrder(value={"Path", "Paragraphs", "SectionsWithHeader"})
@JsonTypeName(value="DocxHeader")
public class DocxHeader {
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;
    public static final String JSON_PROPERTY_PARAGRAPHS = "Paragraphs";
    private List<DocxParagraph> paragraphs = null;
    public static final String JSON_PROPERTY_SECTIONS_WITH_HEADER = "SectionsWithHeader";
    private List<DocxSection> sectionsWithHeader = null;

    public DocxHeader path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Path of the location of this object; leave blank for new tables")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DocxHeader paragraphs(List<DocxParagraph> paragraphs) {
        this.paragraphs = paragraphs;
        return this;
    }

    public DocxHeader addParagraphsItem(DocxParagraph paragraphsItem) {
        if (this.paragraphs == null) {
            this.paragraphs = new ArrayList<DocxParagraph>();
        }
        this.paragraphs.add(paragraphsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Paragraphs in this header")
    @JsonProperty(value="Paragraphs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocxParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public void setParagraphs(List<DocxParagraph> paragraphs) {
        this.paragraphs = paragraphs;
    }

    public DocxHeader sectionsWithHeader(List<DocxSection> sectionsWithHeader) {
        this.sectionsWithHeader = sectionsWithHeader;
        return this;
    }

    public DocxHeader addSectionsWithHeaderItem(DocxSection sectionsWithHeaderItem) {
        if (this.sectionsWithHeader == null) {
            this.sectionsWithHeader = new ArrayList<DocxSection>();
        }
        this.sectionsWithHeader.add(sectionsWithHeaderItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sections that the header is applied to")
    @JsonProperty(value="SectionsWithHeader")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocxSection> getSectionsWithHeader() {
        return this.sectionsWithHeader;
    }

    public void setSectionsWithHeader(List<DocxSection> sectionsWithHeader) {
        this.sectionsWithHeader = sectionsWithHeader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxHeader docxHeader = (DocxHeader)o;
        return Objects.equals(this.path, docxHeader.path) && Objects.equals(this.paragraphs, docxHeader.paragraphs) && Objects.equals(this.sectionsWithHeader, docxHeader.sectionsWithHeader);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.paragraphs, this.sectionsWithHeader);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxHeader {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    paragraphs: ").append(this.toIndentedString(this.paragraphs)).append("\n");
        sb.append("    sectionsWithHeader: ").append(this.toIndentedString(this.sectionsWithHeader)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

