/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Comment in a Word Document")
@JsonPropertyOrder(value={"Path", "Author", "AuthorInitials", "CommentText", "CommentDate", "IsTopLevel", "IsReply", "ParentCommentPath", "Done"})
@JsonTypeName(value="DocxComment")
public class DocxComment {
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;
    public static final String JSON_PROPERTY_AUTHOR = "Author";
    private String author;
    public static final String JSON_PROPERTY_AUTHOR_INITIALS = "AuthorInitials";
    private String authorInitials;
    public static final String JSON_PROPERTY_COMMENT_TEXT = "CommentText";
    private String commentText;
    public static final String JSON_PROPERTY_COMMENT_DATE = "CommentDate";
    private OffsetDateTime commentDate;
    public static final String JSON_PROPERTY_IS_TOP_LEVEL = "IsTopLevel";
    private Boolean isTopLevel;
    public static final String JSON_PROPERTY_IS_REPLY = "IsReply";
    private Boolean isReply;
    public static final String JSON_PROPERTY_PARENT_COMMENT_PATH = "ParentCommentPath";
    private String parentCommentPath;
    public static final String JSON_PROPERTY_DONE = "Done";
    private Boolean done;

    public DocxComment path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to the comment in the document")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DocxComment author(String author) {
        this.author = author;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Author name of the comment")
    @JsonProperty(value="Author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public DocxComment authorInitials(String authorInitials) {
        this.authorInitials = authorInitials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Initials of the author of the comment")
    @JsonProperty(value="AuthorInitials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorInitials() {
        return this.authorInitials;
    }

    public void setAuthorInitials(String authorInitials) {
        this.authorInitials = authorInitials;
    }

    public DocxComment commentText(String commentText) {
        this.commentText = commentText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text content of the comment")
    @JsonProperty(value="CommentText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public DocxComment commentDate(OffsetDateTime commentDate) {
        this.commentDate = commentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date timestamp of the comment")
    @JsonProperty(value="CommentDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCommentDate() {
        return this.commentDate;
    }

    public void setCommentDate(OffsetDateTime commentDate) {
        this.commentDate = commentDate;
    }

    public DocxComment isTopLevel(Boolean isTopLevel) {
        this.isTopLevel = isTopLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the comment is at the top level, false if this comment is a child reply of another comment")
    @JsonProperty(value="IsTopLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsTopLevel() {
        return this.isTopLevel;
    }

    public void setIsTopLevel(Boolean isTopLevel) {
        this.isTopLevel = isTopLevel;
    }

    public DocxComment isReply(Boolean isReply) {
        this.isReply = isReply;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if this comment is a reply to another comment, false otherwise")
    @JsonProperty(value="IsReply")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsReply() {
        return this.isReply;
    }

    public void setIsReply(Boolean isReply) {
        this.isReply = isReply;
    }

    public DocxComment parentCommentPath(String parentCommentPath) {
        this.parentCommentPath = parentCommentPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to the parent of this comment, if this comment is a reply, otherwise this value will be null")
    @JsonProperty(value="ParentCommentPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParentCommentPath() {
        return this.parentCommentPath;
    }

    public void setParentCommentPath(String parentCommentPath) {
        this.parentCommentPath = parentCommentPath;
    }

    public DocxComment done(Boolean done) {
        this.done = done;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if this comment is marked as Done in Word, otherwise it is false")
    @JsonProperty(value="Done")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDone() {
        return this.done;
    }

    public void setDone(Boolean done) {
        this.done = done;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxComment docxComment = (DocxComment)o;
        return Objects.equals(this.path, docxComment.path) && Objects.equals(this.author, docxComment.author) && Objects.equals(this.authorInitials, docxComment.authorInitials) && Objects.equals(this.commentText, docxComment.commentText) && Objects.equals(this.commentDate, docxComment.commentDate) && Objects.equals(this.isTopLevel, docxComment.isTopLevel) && Objects.equals(this.isReply, docxComment.isReply) && Objects.equals(this.parentCommentPath, docxComment.parentCommentPath) && Objects.equals(this.done, docxComment.done);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.author, this.authorInitials, this.commentText, this.commentDate, this.isTopLevel, this.isReply, this.parentCommentPath, this.done);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxComment {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    authorInitials: ").append(this.toIndentedString(this.authorInitials)).append("\n");
        sb.append("    commentText: ").append(this.toIndentedString(this.commentText)).append("\n");
        sb.append("    commentDate: ").append(this.toIndentedString(this.commentDate)).append("\n");
        sb.append("    isTopLevel: ").append(this.toIndentedString(this.isTopLevel)).append("\n");
        sb.append("    isReply: ").append(this.toIndentedString(this.isReply)).append("\n");
        sb.append("    parentCommentPath: ").append(this.toIndentedString(this.parentCommentPath)).append("\n");
        sb.append("    done: ").append(this.toIndentedString(this.done)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

