/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Single object instance, and associated details, detected in an image")
@JsonPropertyOrder(value={"ObjectClassName", "Height", "Width", "Score", "X", "Y"})
@JsonTypeName(value="DetectedObject")
public class DetectedObject {
    public static final String JSON_PROPERTY_OBJECT_CLASS_NAME = "ObjectClassName";
    private String objectClassName;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Integer height;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Integer width;
    public static final String JSON_PROPERTY_SCORE = "Score";
    private Double score;
    public static final String JSON_PROPERTY_X = "X";
    private Integer X;
    public static final String JSON_PROPERTY_Y = "Y";
    private Integer Y;

    public DetectedObject objectClassName(String objectClassName) {
        this.objectClassName = objectClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Class of the object.  Example values are \"person\", \"car\", \"dining table\", etc.")
    @JsonProperty(value="ObjectClassName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getObjectClassName() {
        return this.objectClassName;
    }

    public void setObjectClassName(String objectClassName) {
        this.objectClassName = objectClassName;
    }

    public DetectedObject height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height, in pixels, of the object")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public DetectedObject width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width, in pixels, of the object")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public DetectedObject score(Double score) {
        this.score = score;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Confidence score of detected object; possible values are between 0.0 and 1.0; values closer to 1.0 are higher confidence")
    @JsonProperty(value="Score")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public DetectedObject X(Integer X) {
        this.X = X;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X location, in pixels, of the left side location of the object, with the right side being X + Width")
    @JsonProperty(value="X")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getX() {
        return this.X;
    }

    public void setX(Integer X) {
        this.X = X;
    }

    public DetectedObject Y(Integer Y) {
        this.Y = Y;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y location, in pixels, of the top side location of the object, with the bottom side being Y + Height")
    @JsonProperty(value="Y")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getY() {
        return this.Y;
    }

    public void setY(Integer Y) {
        this.Y = Y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetectedObject detectedObject = (DetectedObject)o;
        return Objects.equals(this.objectClassName, detectedObject.objectClassName) && Objects.equals(this.height, detectedObject.height) && Objects.equals(this.width, detectedObject.width) && Objects.equals(this.score, detectedObject.score) && Objects.equals(this.X, detectedObject.X) && Objects.equals(this.Y, detectedObject.Y);
    }

    public int hashCode() {
        return Objects.hash(this.objectClassName, this.height, this.width, this.score, this.X, this.Y);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DetectedObject {\n");
        sb.append("    objectClassName: ").append(this.toIndentedString(this.objectClassName)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    X: ").append(this.toIndentedString(this.X)).append("\n");
        sb.append("    Y: ").append(this.toIndentedString(this.Y)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

